/*
 * Decompiled with CFR 0.152.
 */
package in.srain.cube.mints.base;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import in.srain.cube.R;

public class TitleHeaderBar
extends RelativeLayout {
    private TextView mCenterTitleTextView;
    private ImageView mLeftReturnImageView;
    private RelativeLayout mLeftViewContainer;
    private RelativeLayout mRightViewContainer;
    private RelativeLayout mCenterViewContainer;
    private String mTitle;

    public TitleHeaderBar(Context context) {
        this(context, null);
    }

    public TitleHeaderBar(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public TitleHeaderBar(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        LayoutInflater.from((Context)context).inflate(this.getHeaderViewLayoutId(), (ViewGroup)this);
        this.mLeftViewContainer = (RelativeLayout)this.findViewById(R.id.ly_title_bar_left);
        this.mCenterViewContainer = (RelativeLayout)this.findViewById(R.id.ly_title_bar_center);
        this.mRightViewContainer = (RelativeLayout)this.findViewById(R.id.ly_title_bar_right);
        this.mLeftReturnImageView = (ImageView)this.findViewById(R.id.iv_title_bar_left);
        this.mCenterTitleTextView = (TextView)this.findViewById(R.id.tv_title_bar_title);
    }

    protected int getHeaderViewLayoutId() {
        return R.layout.cube_mints_base_header_bar_title;
    }

    public ImageView getLeftImageView() {
        return this.mLeftReturnImageView;
    }

    public TextView getTitleTextView() {
        return this.mCenterTitleTextView;
    }

    public void setTitle(String title) {
        this.mTitle = title;
        this.mCenterTitleTextView.setText((CharSequence)title);
    }

    public String getTitle() {
        return this.mTitle;
    }

    private RelativeLayout.LayoutParams makeLayoutParams(View view) {
        ViewGroup.LayoutParams lpOld = view.getLayoutParams();
        RelativeLayout.LayoutParams lp = null;
        lp = lpOld == null ? new RelativeLayout.LayoutParams(-2, -1) : new RelativeLayout.LayoutParams(lpOld.width, lpOld.height);
        return lp;
    }

    public void setCustomizedLeftView(View view) {
        this.mLeftReturnImageView.setVisibility(8);
        RelativeLayout.LayoutParams lp = this.makeLayoutParams(view);
        lp.addRule(15);
        lp.addRule(9);
        this.getLeftViewContainer().addView(view, (ViewGroup.LayoutParams)lp);
    }

    public void setCustomizedLeftView(int layoutId) {
        View view = TitleHeaderBar.inflate((Context)this.getContext(), (int)layoutId, null);
        this.setCustomizedLeftView(view);
    }

    public void setCustomizedCenterView(View view) {
        this.mCenterTitleTextView.setVisibility(8);
        RelativeLayout.LayoutParams lp = this.makeLayoutParams(view);
        lp.addRule(13);
        this.getCenterViewContainer().addView(view, (ViewGroup.LayoutParams)lp);
    }

    public void setCustomizedCenterView(int layoutId) {
        View view = TitleHeaderBar.inflate((Context)this.getContext(), (int)layoutId, null);
        this.setCustomizedCenterView(view);
    }

    public void setCustomizedRightView(View view) {
        RelativeLayout.LayoutParams lp = this.makeLayoutParams(view);
        lp.addRule(15);
        lp.addRule(11);
        this.getRightViewContainer().addView(view, (ViewGroup.LayoutParams)lp);
    }

    public RelativeLayout getLeftViewContainer() {
        return this.mLeftViewContainer;
    }

    public RelativeLayout getCenterViewContainer() {
        return this.mCenterViewContainer;
    }

    public RelativeLayout getRightViewContainer() {
        return this.mRightViewContainer;
    }

    public void setLeftOnClickListener(View.OnClickListener l) {
        this.mLeftViewContainer.setOnClickListener(l);
    }

    public void setCenterOnClickListener(View.OnClickListener l) {
        this.mCenterViewContainer.setOnClickListener(l);
    }

    public void setRightOnClickListener(View.OnClickListener l) {
        this.mRightViewContainer.setOnClickListener(l);
    }
}

