/*
 * Decompiled with CFR 0.152.
 */
package in.srain.cube.request;

import android.text.TextUtils;
import in.srain.cube.cache.CacheManager;
import in.srain.cube.cache.CacheResultType;
import in.srain.cube.concurrent.SimpleTask;
import in.srain.cube.request.CacheAbleRequestHandler;
import in.srain.cube.request.FailData;
import in.srain.cube.request.ICacheAbleRequest;
import in.srain.cube.request.JsonData;
import in.srain.cube.request.RequestBase;
import in.srain.cube.request.RequestCacheManager;
import in.srain.cube.request.RequestManager;
import in.srain.cube.util.CLog;
import in.srain.cube.util.CubeDebug;
import java.net.URI;
import java.net.URISyntaxException;

public class CacheAbleRequest<T>
extends RequestBase<T>
implements ICacheAbleRequest<T> {
    protected static final boolean DEBUG = CubeDebug.DEBUG_CACHE;
    protected static final String LOG_TAG = "cube-cache-request";
    private CacheAbleRequestHandler<T> mHandler;
    private T mCacheData;
    private boolean mOutOfDate;
    private String mCacheKey = null;
    private int mTimeout = 0;
    private boolean mHasTimeout = false;
    private boolean mUseCacheAnyway = false;
    private boolean mHasNotified = false;
    protected boolean mForceQueryFromServer = false;
    private String mInitDataPath;
    private boolean mDisableCache = false;
    private long mCacheTime;

    public CacheAbleRequest() {
    }

    public CacheAbleRequest(CacheAbleRequestHandler<T> handler) {
        this.setCacheAbleRequestHandler(handler);
    }

    public void setCacheAbleRequestHandler(CacheAbleRequestHandler<T> handler) {
        this.mHandler = handler;
    }

    public void forceQueryFromServer(boolean force) {
        this.mForceQueryFromServer = force;
    }

    @Override
    public void doSendRequest() {
        RequestCacheManager.getInstance().requestCache(this);
    }

    @Override
    protected T doRequestSync() {
        Object data = RequestCacheManager.getInstance().requestCacheSync(this);
        if (data == null) {
            data = RequestManager.getInstance().getRequestProxy().requestSync(this);
        }
        return data;
    }

    @Override
    protected void prepareRequest() {
    }

    @Override
    public void setTimeout(int timeOut) {
        this.mTimeout = timeOut;
    }

    @Override
    public CacheAbleRequest<T> setUseCacheAnyway(boolean use) {
        this.mUseCacheAnyway = use;
        return this;
    }

    @Override
    public boolean useCacheAnyway() {
        return this.mUseCacheAnyway;
    }

    @Override
    public void onRequestSuccess(T data) {
        if (DEBUG) {
            CLog.d((String)LOG_TAG, (String)"%s, onRequestSuccess", (Object[])new Object[]{this.getCacheKey()});
        }
        if (this.hasBeenCanceled()) {
            return;
        }
        if (null != this.mHandler) {
            this.mHandler.onRequestFinish(data);
            if (this.mCacheData == null || !this.mHasTimeout && !this.mUseCacheAnyway) {
                this.notifyRequestFinish(ResultType.USE_DATA_FROM_SERVER, data, false);
            } else if (DEBUG) {
                CLog.d((String)LOG_TAG, (String)"%s, will not notifyRequestFinish", (Object[])new Object[]{this.getCacheKey()});
            }
        }
    }

    @Override
    public void onRequestFail(FailData failData) {
        if (DEBUG) {
            CLog.d((String)LOG_TAG, (String)"%s, onRequestFail", (Object[])new Object[]{this.getCacheKey()});
        }
        if (this.hasBeenCanceled()) {
            return;
        }
        if (null != this.mHandler) {
            this.mHandler.onRequestFail(failData);
            if (this.mCacheData != null && !this.cacheIsDisabled() && !this.mUseCacheAnyway) {
                this.notifyRequestFinish(ResultType.USE_CACHE_ON_FAIL, this.mCacheData, true);
            }
        }
    }

    @Override
    public void onNoCacheData(CacheManager cacheManager) {
        if (DEBUG) {
            CLog.d((String)LOG_TAG, (String)"%s, onNoCacheData", (Object[])new Object[]{this.getCacheKey()});
        }
        if (this.hasBeenCanceled()) {
            return;
        }
        this.doQueryFromServer();
        this.beginTimeout();
    }

    protected void doQueryFromServer() {
        RequestManager.getInstance().getRequestProxy().sendRequest(this);
    }

    protected boolean cacheRequestResult() {
        return this.mForceQueryFromServer || !this.cacheIsDisabled();
    }

    @Override
    public boolean cacheIsDisabled() {
        if (this.mForceQueryFromServer) {
            return true;
        }
        return this.mDisableCache;
    }

    @Override
    public void onCacheData(CacheResultType cacheResultType, T data, boolean outOfDate) {
        if (DEBUG) {
            CLog.d((String)LOG_TAG, (String)"%s, onQueryFinish, out of date: %s", (Object[])new Object[]{this.getCacheKey(), outOfDate});
        }
        if (this.hasBeenCanceled()) {
            return;
        }
        this.mCacheData = data;
        this.mOutOfDate = outOfDate;
        if (this.mHandler != null) {
            this.mHandler.onCacheData(data, outOfDate);
            if (this.mUseCacheAnyway) {
                this.notifyRequestFinish(ResultType.USE_CACHE_ANYWAY, data, this.mOutOfDate);
            } else if (!outOfDate) {
                this.notifyRequestFinish(ResultType.USE_CACHE_NOT_EXPIRED, data, false);
            }
        }
    }

    @Override
    public long getCacheTime() {
        return this.mCacheTime;
    }

    @Override
    public String getCacheKey() {
        if (this.mCacheKey == null) {
            String cacheKey = null;
            String url = this.getRequestData().getRequestUrl();
            try {
                URI uri = null;
                uri = new URI(url);
                cacheKey = uri.getPath();
                if (cacheKey.startsWith("/")) {
                    cacheKey = cacheKey.substring(1);
                }
                cacheKey = cacheKey.replace("/", "-");
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
            if (TextUtils.isEmpty(cacheKey)) {
                throw new RuntimeException("Cache key is null");
            }
            this.mCacheKey = cacheKey;
        }
        return this.mCacheKey;
    }

    @Override
    public String getAssertInitDataPath() {
        return this.mInitDataPath;
    }

    @Override
    public T onDataFromServer(String data) {
        if (DEBUG) {
            CLog.d((String)LOG_TAG, (String)"%s, onDataFromServer", (Object[])new Object[]{this.getCacheKey()});
        }
        Object ret = super.onDataFromServer(data);
        if (!TextUtils.isEmpty((CharSequence)data) && ret != null && this.cacheRequestResult()) {
            RequestCacheManager.getInstance().setCacheData(this.getCacheKey(), data);
        }
        return ret;
    }

    @Override
    public T processOriginDataFromServer(JsonData rawData) {
        return this.mHandler.processOriginData(rawData);
    }

    @Override
    public T processRawDataFromCache(JsonData rawData) {
        return this.mHandler.processOriginData(rawData);
    }

    private void notifyRequestFinish(ResultType type, T cacheData, boolean outOfDate) {
        if (DEBUG) {
            CLog.d((String)LOG_TAG, (String)"%s, notifyRequestFinish: %s, %s", (Object[])new Object[]{this.getCacheKey(), type, outOfDate});
        }
        if (this.mHasNotified) {
            return;
        }
        this.mHasNotified = true;
        this.mHandler.onCacheAbleRequestFinish(cacheData, type, outOfDate);
    }

    private void timeout() {
        this.mHasTimeout = true;
        if (this.mCacheData != null && this.mHandler != null) {
            this.notifyRequestFinish(ResultType.USE_CACHE_ON_TIMEOUT, this.mCacheData, true);
        }
    }

    private void beginTimeout() {
        if (this.mTimeout > 0 && this.mCacheData != null) {
            SimpleTask.postDelay(new Runnable(){

                @Override
                public void run() {
                    CacheAbleRequest.this.timeout();
                }
            }, this.mTimeout);
        }
    }

    @Override
    public CacheAbleRequest<T> setCacheKey(String cacheKey) {
        this.mCacheKey = cacheKey;
        return this;
    }

    @Override
    public CacheAbleRequest<T> setDisableCache(boolean disable) {
        this.mDisableCache = disable;
        return this;
    }

    @Override
    public CacheAbleRequest<T> setAssertInitDataPath(String path) {
        this.mInitDataPath = path;
        return this;
    }

    @Override
    public CacheAbleRequest<T> setCacheTime(long time) {
        this.mCacheTime = time;
        return this;
    }

    public static enum ResultType {
        USE_CACHE_NOT_EXPIRED,
        USE_CACHE_ANYWAY,
        USE_CACHE_ON_TIMEOUT,
        USE_DATA_FROM_SERVER,
        USE_CACHE_ON_FAIL;

    }
}

