/*
 * Decompiled with CFR 0.152.
 */
package in.srain.cube.request;

import in.srain.cube.concurrent.SimpleExecutor;
import in.srain.cube.concurrent.SimpleTask;
import in.srain.cube.request.FailData;
import in.srain.cube.request.IRequest;
import in.srain.cube.request.IRequestProxy;
import in.srain.cube.request.RequestData;
import in.srain.cube.request.sender.BaseRequestSender;
import in.srain.cube.request.sender.RequestSenderFactory;
import in.srain.cube.util.CLog;
import in.srain.cube.util.CubeDebug;

public class DefaultRequestProxy
implements IRequestProxy {
    private static final boolean DEBUG = CubeDebug.DEBUG_REQUEST;
    private static final String LOG_TAG = CubeDebug.DEBUG_REQUEST_LOG_TAG;
    private static IRequestProxy sInstance;
    private SimpleExecutor mSimpleExecutor = SimpleExecutor.create("cube-request-", 2, 4);

    protected DefaultRequestProxy() {
    }

    public static IRequestProxy getInstance() {
        if (sInstance == null) {
            sInstance = new DefaultRequestProxy();
        }
        return sInstance;
    }

    protected static <T> T doSyncRequest(IRequest<T> request) {
        T data = null;
        try {
            BaseRequestSender requestSender;
            StringBuilder sb = new StringBuilder();
            RequestData requestData = request.getRequestData();
            if (DEBUG) {
                CLog.d((String)LOG_TAG, (String)"%s", (Object[])new Object[]{requestData});
            }
            if ((requestSender = RequestSenderFactory.create(request)) != null) {
                requestSender.send();
                requestSender.getResponse(sb);
                if (DEBUG) {
                    CLog.d((String)LOG_TAG, (String)"%s: %s", (Object[])new Object[]{requestData, sb.toString()});
                }
                data = request.onDataFromServer(sb.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            request.setFailData(FailData.networkError(request));
        }
        return data;
    }

    @Override
    public <T> T requestSync(final IRequest<T> request) {
        final T data = DefaultRequestProxy.doSyncRequest(request);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (data == null) {
                    request.onRequestFail(request.getFailData());
                } else {
                    request.onRequestSuccess(data);
                }
            }
        };
        SimpleTask.post(runnable);
        return data;
    }

    @Override
    public <T> void sendRequest(IRequest<T> request) {
        DoRequestTask doRequestTask = new DoRequestTask(request);
        this.mSimpleExecutor.execute(doRequestTask);
    }

    private static class DoRequestTask<T>
    extends SimpleTask {
        private T mData;
        private IRequest<T> mRequest;

        private DoRequestTask(IRequest<T> request) {
            this.mRequest = request;
        }

        @Override
        public void doInBackground() {
            this.mData = DefaultRequestProxy.doSyncRequest(this.mRequest);
        }

        @Override
        public void onFinish(boolean canceled) {
            if (this.mData == null) {
                this.mRequest.onRequestFail(this.mRequest.getFailData());
            } else {
                this.mRequest.onRequestSuccess(this.mData);
            }
        }
    }
}

