/*
 * Decompiled with CFR 0.152.
 */
package in.srain.cube.request;

import in.srain.cube.request.IRequest;

public class FailData {
    public static final int ERROR_UNKNOWN = 0;
    public static final int ERROR_INPUT = 1;
    public static final int ERROR_NETWORK = 2;
    public static final int ERROR_DATA_FORMAT = 3;
    public static final int ERROR_CUSTOMIZED = 100;
    public int mErrorType = 3;
    public int mCustomErrorType;
    public IRequest<?> mRequest;
    public Object mData;

    public static FailData unknown(IRequest<?> request) {
        return new FailData(request, 0, -1, null);
    }

    public static FailData inputError(IRequest<?> request) {
        return new FailData(request, 1, -1, null);
    }

    public static FailData networkError(IRequest<?> request) {
        return new FailData(request, 2, -1, null);
    }

    public static FailData dataFormatError(IRequest<?> request, String content) {
        return new FailData(request, 3, -1, content);
    }

    public static FailData customizedError(IRequest<?> request, int error, Object data) {
        return new FailData(request, 100, error, data);
    }

    private FailData(IRequest<?> request, int errorType, int customErrorType, Object data) {
        this.mRequest = request;
        this.mErrorType = errorType;
        this.mCustomErrorType = customErrorType;
        this.mData = data;
    }

    public int getErrorType() {
        return this.mErrorType;
    }

    public int getCustomErrorType() {
        return this.mCustomErrorType;
    }

    public IRequest<?> getRequest() {
        return this.mRequest;
    }

    public <T> T getData(Class<T> cls) {
        if (this.mData == null || !cls.isInstance(this.mData)) {
            return null;
        }
        return (T)this.mData;
    }

    public Object getRawData() {
        return this.mData;
    }
}

