/*
 * Decompiled with CFR 0.152.
 */
package in.srain.cube.request;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

public final class JsonData {
    private Object mJson;
    private static final String EMPTY_STRING = "";
    private static final JSONArray EMPTY_JSON_ARRAY = new JSONArray();
    private static final JSONObject EMPTY_JSON_OBJECT = new JSONObject();

    public static JsonData newMap() {
        return JsonData.create(new HashMap());
    }

    public static JsonData newList() {
        return JsonData.create(new ArrayList());
    }

    public static JsonData create(String str) {
        Object object = null;
        if (str != null && str.length() >= 0) {
            try {
                JSONTokener jsonTokener = new JSONTokener(str);
                object = jsonTokener.nextValue();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return JsonData.create(object);
    }

    public static JsonData create(Object o) {
        JsonData json = new JsonData();
        if (o instanceof JSONArray || o instanceof JSONObject) {
            json.mJson = o;
        }
        if (o instanceof Map) {
            json.mJson = new JSONObject((Map)o);
        }
        if (o instanceof Collection) {
            json.mJson = new JSONArray((Collection)o);
        }
        return json;
    }

    public Object getRawData() {
        return this.mJson;
    }

    public JsonData optJson(String name) {
        Object ret = null;
        if (this.mJson instanceof JSONObject) {
            ret = ((JSONObject)this.mJson).opt(name);
        }
        return JsonData.create(ret);
    }

    public JsonData optJson(int index) {
        Object ret = null;
        if (this.mJson instanceof JSONArray) {
            ret = ((JSONArray)this.mJson).opt(index);
        }
        return JsonData.create(ret);
    }

    public String optString(String name) {
        return this.optMapOrNew().optString(name);
    }

    public String optString(String name, String fallback) {
        return this.optMapOrNew().optString(name, fallback);
    }

    public String optString(int index) {
        return this.optArrayOrNew().optString(index);
    }

    public String optString(int index, String fallback) {
        return this.optArrayOrNew().optString(index, fallback);
    }

    public int optInt(String name) {
        return this.optMapOrNew().optInt(name);
    }

    public int optInt(String name, int fallback) {
        return this.optMapOrNew().optInt(name, fallback);
    }

    public int optInt(int index) {
        return this.optArrayOrNew().optInt(index);
    }

    public int optInt(int index, int fallback) {
        return this.optArrayOrNew().optInt(index, fallback);
    }

    public boolean optBoolean(String name) {
        return this.optMapOrNew().optBoolean(name);
    }

    public boolean optBoolean(String name, boolean fallback) {
        return this.optMapOrNew().optBoolean(name, fallback);
    }

    public boolean optBoolean(int index) {
        return this.optArrayOrNew().optBoolean(index);
    }

    public boolean optBoolean(int index, boolean fallback) {
        return this.optArrayOrNew().optBoolean(index, fallback);
    }

    public double optDouble(String name) {
        return this.optMapOrNew().optDouble(name);
    }

    public double optDouble(String name, double fallback) {
        return this.optMapOrNew().optDouble(name, fallback);
    }

    public double optDouble(int index) {
        return this.optArrayOrNew().optDouble(index);
    }

    public double optDouble(int index, double fallback) {
        return this.optArrayOrNew().optDouble(index, fallback);
    }

    public boolean has(String name) {
        return this.optMapOrNew().has(name);
    }

    public boolean has(int index) {
        return this.optArrayOrNew().length() > index;
    }

    public JSONObject optMapOrNew() {
        if (this.mJson instanceof JSONObject) {
            return (JSONObject)this.mJson;
        }
        return EMPTY_JSON_OBJECT;
    }

    private Object valueForPut(Object value) {
        if (value instanceof JsonData) {
            return ((JsonData)value).getRawData();
        }
        return value;
    }

    public void put(String key, Object value) {
        if (this.mJson instanceof JSONObject) {
            try {
                ((JSONObject)this.mJson).put(key, this.valueForPut(value));
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    public void put(Object value) {
        if (this.mJson instanceof JSONArray) {
            ((JSONArray)this.mJson).put(this.valueForPut(value));
        }
    }

    public void put(int index, Object value) {
        if (this.mJson instanceof JSONArray) {
            try {
                ((JSONArray)this.mJson).put(index, this.valueForPut(value));
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
    }

    public JsonData editMap(int index) {
        if (this.has(index)) {
            return this.optJson(index);
        }
        JsonData map = JsonData.newMap();
        this.put(index, (Object)map);
        return map;
    }

    public JsonData editMap() {
        JsonData map = JsonData.newMap();
        this.put(map);
        return map;
    }

    public JsonData editMap(String key) {
        if (this.has(key)) {
            return this.optJson(key);
        }
        JsonData map = JsonData.newMap();
        this.put(key, (Object)map);
        return map;
    }

    public JsonData editList(String key) {
        if (this.has(key)) {
            return this.optJson(key);
        }
        JsonData list = JsonData.newList();
        this.put(key, (Object)list);
        return list;
    }

    public JsonData editList(int index) {
        if (this.has(index)) {
            return this.optJson(index);
        }
        JsonData list = JsonData.newList();
        this.put(index, (Object)list);
        return list;
    }

    public JsonData editList() {
        JsonData list = JsonData.newList();
        this.put(list);
        return list;
    }

    public JSONArray optArrayOrNew() {
        if (this.mJson instanceof JSONArray) {
            return (JSONArray)this.mJson;
        }
        return EMPTY_JSON_ARRAY;
    }

    public int length() {
        if (this.mJson instanceof JSONArray) {
            return ((JSONArray)this.mJson).length();
        }
        if (this.mJson instanceof JSONObject) {
            return ((JSONObject)this.mJson).length();
        }
        return 0;
    }

    public Iterator<String> keys() {
        return this.optMapOrNew().keys();
    }

    public String toString() {
        if (this.mJson instanceof JSONArray) {
            return ((JSONArray)this.mJson).toString();
        }
        if (this.mJson instanceof JSONObject) {
            return ((JSONObject)this.mJson).toString();
        }
        return EMPTY_STRING;
    }

    public ArrayList<JsonData> toArrayList() {
        ArrayList<JsonData> arrayList;
        block3: {
            block2: {
                arrayList = new ArrayList<JsonData>();
                if (!(this.mJson instanceof JSONArray)) break block2;
                JSONArray array = (JSONArray)this.mJson;
                for (int i = 0; i < array.length(); ++i) {
                    arrayList.add(i, JsonData.create(array.opt(i)));
                }
                break block3;
            }
            if (!(this.mJson instanceof JSONObject)) break block3;
            JSONObject json = (JSONObject)this.mJson;
            Iterator it = json.keys();
            while (it.hasNext()) {
                String key = (String)it.next();
                arrayList.add(JsonData.create(json.opt(key)));
            }
        }
        return arrayList;
    }
}

