/*
 * Decompiled with CFR 0.152.
 */
package in.srain.cube.request;

import in.srain.cube.request.FailData;
import in.srain.cube.request.IRequest;
import in.srain.cube.request.JsonData;
import in.srain.cube.request.RequestData;

public abstract class RequestBase<T>
implements IRequest<T> {
    private RequestData mRequestData = new RequestData();
    private FailData mFailData;
    private boolean mHasBeenCanceled = false;

    @Override
    public RequestData getRequestData() {
        return this.mRequestData;
    }

    @Override
    public void send() {
        this.prepareRequest();
        this.doSendRequest();
    }

    @Override
    public T requestSync() {
        this.prepareRequest();
        return this.doRequestSync();
    }

    @Override
    public void cancelRequest() {
        this.mHasBeenCanceled = true;
        this.onCancel();
    }

    @Override
    public T onDataFromServer(String data) {
        JsonData jsonData = JsonData.create(data);
        if (jsonData == null || jsonData.length() == 0) {
            this.setFailData(FailData.dataFormatError(this, data));
            return null;
        }
        return this.processOriginDataFromServer(jsonData);
    }

    protected boolean hasBeenCanceled() {
        return this.mHasBeenCanceled;
    }

    protected void onCancel() {
    }

    @Override
    public RequestBase setFailData(FailData failData) {
        this.mFailData = failData;
        return this;
    }

    @Override
    public FailData getFailData() {
        return this.mFailData;
    }

    protected abstract void doSendRequest();

    protected abstract T doRequestSync();

    protected abstract void prepareRequest();
}

