/*
 * Decompiled with CFR 0.152.
 */
package in.srain.cube.request;

import android.text.TextUtils;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;

public class RequestData {
    private static final String EMPTY = "";
    private static final String CHAR_QM = "?";
    private static final String CHAR_AND = "&";
    private static final String CHAR_EQ = "=";
    private static final String CHAR_SET = "UTF-8";
    public String mUrl;
    private HashMap<String, Object> mQueryData;
    private HashMap<String, Object> mPostData;
    private HashMap<String, Object> mHeaderData;
    private HashMap<String, UploadFileInfo> mUploadFileInfoHashMap;
    private boolean mUsePost = false;
    private String mTag;

    public static String buildQueryString(Map<String, ?> data, String url) {
        if (data == null || data.size() == 0) {
            return url;
        }
        StringBuilder sb = new StringBuilder();
        boolean append = false;
        if (url != null) {
            sb.append(url);
            if (url.contains(CHAR_QM)) {
                append = true;
            } else {
                sb.append(CHAR_QM);
            }
        }
        for (Map.Entry<String, ?> item : data.entrySet()) {
            if (append) {
                sb.append(CHAR_AND);
            } else {
                append = true;
            }
            try {
                if (TextUtils.isEmpty((CharSequence)item.getKey())) continue;
                sb.append(URLEncoder.encode(item.getKey(), CHAR_SET));
                sb.append(CHAR_EQ);
                if (item.getValue() == null) continue;
                sb.append(URLEncoder.encode(item.getValue().toString(), CHAR_SET));
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        return sb.toString();
    }

    public RequestData addPostData(String key, Object data) {
        if (this.mPostData == null) {
            this.mPostData = new HashMap();
        }
        this.mPostData.put(key, data);
        return this;
    }

    public RequestData addHeader(String key, Object data) {
        if (this.mHeaderData == null) {
            this.mHeaderData = new HashMap();
        }
        this.mHeaderData.put(key, data);
        return this;
    }

    public RequestData addPostData(Map<String, ?> data) {
        if (this.mPostData == null) {
            this.mPostData = new HashMap();
        }
        this.mPostData.putAll(data);
        return this;
    }

    public RequestData addQueryData(String key, Object data) {
        if (this.mQueryData == null) {
            this.mQueryData = new HashMap();
        }
        this.mQueryData.put(key, data);
        return this;
    }

    public RequestData addQueryData(Map<String, ?> data) {
        if (this.mQueryData == null) {
            this.mQueryData = new HashMap();
        }
        this.mQueryData.putAll(data);
        return this;
    }

    public String getRequestUrl() {
        if (this.mQueryData != null) {
            return RequestData.buildQueryString(this.mQueryData, this.mUrl);
        }
        return this.mUrl;
    }

    public RequestData setRequestUrl(String url) {
        this.mUrl = url;
        return this;
    }

    public HashMap<String, Object> getHeaderData() {
        return this.mHeaderData;
    }

    public HashMap<String, Object> getQueryData() {
        return this.mQueryData;
    }

    public HashMap<String, Object> getPostData() {
        return this.mPostData;
    }

    public RequestData usePost(boolean use) {
        this.mUsePost = use;
        return this;
    }

    public RequestData addFile(String fieldName, String uploadFile) {
        this.addFile(fieldName, uploadFile, null);
        return this;
    }

    public RequestData addFile(String fieldName, String uploadFile, String fileName) {
        this.addFile(fieldName, new File(uploadFile), fileName);
        return this;
    }

    public RequestData addFile(String fieldName, File uploadFile) {
        this.addFile(fieldName, uploadFile, null);
        return this;
    }

    public RequestData addFile(String fieldName, File uploadFile, String fileName) {
        if (this.mUploadFileInfoHashMap == null) {
            this.mUploadFileInfoHashMap = new HashMap();
        }
        UploadFileInfo uploadFileInfo = new UploadFileInfo();
        uploadFileInfo.fieldName = fieldName;
        uploadFileInfo.uploadFile = uploadFile;
        uploadFileInfo.fileName = fileName;
        this.mUploadFileInfoHashMap.put(fieldName, uploadFileInfo);
        return this;
    }

    public String getTag() {
        return this.mTag;
    }

    public RequestData setTag(String tag) {
        this.mTag = tag;
        return this;
    }

    public String getPostString() {
        if (this.mPostData == null || this.mPostData.size() == 0) {
            return EMPTY;
        }
        return RequestData.buildQueryString(this.mPostData, null);
    }

    public boolean shouldPost() {
        return this.mUsePost || this.mPostData != null && this.mPostData.size() > 0 || this.isMultiPart();
    }

    public HashMap<String, UploadFileInfo> getUploadFiles() {
        return this.mUploadFileInfoHashMap;
    }

    public boolean isMultiPart() {
        return this.mUploadFileInfoHashMap != null && this.mUploadFileInfoHashMap.size() > 0;
    }

    public String toString() {
        return String.format("RequestData: [%s, G: %s, P: %s, F: %s]", this.getRequestUrl(), this.mQueryData, this.mPostData, this.mUploadFileInfoHashMap);
    }

    public static class UploadFileInfo {
        public File uploadFile;
        public String fileName;
        public String fieldName;

        public String toString() {
            return String.format("UploadFileInfo:[%s %s %s]", this.fieldName, this.fileName, this.uploadFile);
        }
    }
}

