/*
 * Decompiled with CFR 0.152.
 */
package in.srain.cube.request.sender;

import in.srain.cube.request.IRequest;
import in.srain.cube.request.RequestData;
import in.srain.cube.request.sender.IRequestSender;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.util.HashMap;
import java.util.Map;

public abstract class BaseRequestSender
implements IRequestSender {
    protected static final String EMPTY_VALUE = "";
    protected HttpURLConnection mHttpURLConnection;
    protected RequestData mRequestData;
    protected IRequest<?> mRequest;

    public BaseRequestSender(IRequest<?> request, HttpURLConnection httpURLConnection) {
        this.mRequest = request;
        this.mHttpURLConnection = httpURLConnection;
        this.mRequestData = request.getRequestData();
    }

    @Override
    public void setup() throws IOException {
        HashMap<String, Object> data = this.mRequestData.getHeaderData();
        if (data == null || data.size() == 0) {
            return;
        }
        for (Map.Entry<String, Object> item : data.entrySet()) {
            String key = item.getKey();
            Object value = item.getValue();
            if (value == null) {
                value = EMPTY_VALUE;
            }
            this.mHttpURLConnection.setRequestProperty(key, value.toString());
        }
    }

    public void getResponse(StringBuilder sb) throws IOException {
        BufferedReader reader;
        BufferedInputStream ips;
        int status = this.mHttpURLConnection.getResponseCode();
        if (status == 200) {
            int bufferLength;
            ips = new BufferedInputStream(this.mHttpURLConnection.getInputStream());
            reader = new BufferedReader(new InputStreamReader((InputStream)ips, "UTF-8"));
            char[] buffer = new char[1024];
            while ((bufferLength = reader.read(buffer, 0, buffer.length)) > 0) {
                sb.append(buffer, 0, bufferLength);
            }
        } else {
            throw new IOException("Server returned non-OK status: " + status);
        }
        reader.close();
        ((InputStream)ips).close();
        this.mHttpURLConnection.disconnect();
    }
}

