/*
 * Decompiled with CFR 0.152.
 */
package in.srain.cube.request.sender;

import android.text.TextUtils;
import in.srain.cube.request.IRequest;
import in.srain.cube.request.RequestData;
import in.srain.cube.request.sender.PostRequestSender;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;

public class MultiPartRequestSender
extends PostRequestSender {
    private static final String LINE_FEED = "\r\n";
    private static final String CHARSET_DEFAULT = "UTF-8";
    private String mBoundary;
    private String mCharset = "UTF-8";
    private OutputStream mOutputStream;
    private PrintWriter mWriter;

    public MultiPartRequestSender(IRequest<?> request, HttpURLConnection httpURLConnection) {
        super(request, httpURLConnection);
    }

    @Override
    public void setup() throws IOException {
        super.setup();
        this.mBoundary = "===" + System.currentTimeMillis() + "===";
        this.mHttpURLConnection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + this.mBoundary);
        this.mOutputStream = this.mHttpURLConnection.getOutputStream();
        this.mWriter = new PrintWriter((Writer)new OutputStreamWriter(this.mOutputStream), true);
    }

    @Override
    public void send() throws IOException {
        HashMap<String, RequestData.UploadFileInfo> uploadFiles = this.mRequestData.getUploadFiles();
        HashMap<String, Object> mPostData = this.mRequestData.getPostData();
        if (mPostData != null && mPostData.size() != 0) {
            for (Map.Entry<String, Object> entry : mPostData.entrySet()) {
                Object value = entry.getValue();
                if (value == null) {
                    value = "";
                }
                this.addFormField(entry.getKey(), value.toString());
            }
        }
        for (Map.Entry<String, Object> entry : uploadFiles.entrySet()) {
            RequestData.UploadFileInfo uploadFileInfo = (RequestData.UploadFileInfo)entry.getValue();
            this.addFilePart(uploadFileInfo.fieldName, uploadFileInfo.uploadFile, uploadFileInfo.fileName);
        }
    }

    @Override
    public void getResponse(StringBuilder sb) throws IOException {
        this.mWriter.append(LINE_FEED).flush();
        this.mWriter.append("--" + this.mBoundary + "--").append(LINE_FEED);
        this.mWriter.close();
        super.getResponse(sb);
    }

    public void addFormField(String name, String value) {
        this.mWriter.append("--" + this.mBoundary).append(LINE_FEED);
        this.mWriter.append("Content-Disposition: form-data; name=\"" + name + "\"").append(LINE_FEED);
        this.mWriter.append("Content-Type: text/plain; charset=" + this.mCharset).append(LINE_FEED);
        this.mWriter.append(LINE_FEED);
        this.mWriter.append(value).append(LINE_FEED);
        this.mWriter.flush();
    }

    public void addFilePart(String fieldName, File uploadFile, String fileName) throws IOException {
        if (TextUtils.isEmpty((CharSequence)fileName)) {
            fileName = uploadFile.getName();
        }
        this.mWriter.append("--" + this.mBoundary).append(LINE_FEED);
        this.mWriter.append("Content-Disposition: form-data; name=\"" + fieldName + "\"; filename=\"" + fileName + "\"").append(LINE_FEED);
        this.mWriter.append("Content-Type: " + URLConnection.guessContentTypeFromName(fileName)).append(LINE_FEED);
        this.mWriter.append("Content-Transfer-Encoding: binary").append(LINE_FEED);
        this.mWriter.append(LINE_FEED);
        this.mWriter.flush();
        FileInputStream inputStream = new FileInputStream(uploadFile);
        byte[] buffer = new byte[4096];
        int bytesRead = -1;
        while ((bytesRead = inputStream.read(buffer)) != -1) {
            this.mOutputStream.write(buffer, 0, bytesRead);
        }
        this.mOutputStream.flush();
        inputStream.close();
        this.mWriter.append(LINE_FEED);
        this.mWriter.flush();
    }
}

