/*
 * Decompiled with CFR 0.152.
 */
package in.srain.cube.request.sender;

import in.srain.cube.request.FailData;
import in.srain.cube.request.IRequest;
import in.srain.cube.request.RequestData;
import in.srain.cube.request.sender.BaseRequestSender;
import in.srain.cube.request.sender.GetRequestSender;
import in.srain.cube.request.sender.MultiPartRequestSender;
import in.srain.cube.request.sender.PostRequestSender;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;

public class RequestSenderFactory {
    public static <T> BaseRequestSender create(IRequest<T> request) {
        BaseRequestSender sender = null;
        try {
            RequestData requestData = request.getRequestData();
            URL url = new URL(requestData.getRequestUrl());
            HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
            sender = !requestData.shouldPost() ? new GetRequestSender(request, urlConnection) : (requestData.isMultiPart() ? new MultiPartRequestSender(request, urlConnection) : new PostRequestSender(request, urlConnection));
            sender.setup();
        }
        catch (MalformedURLException e) {
            request.setFailData(FailData.inputError(request));
        }
        catch (IOException e) {
            request.setFailData(FailData.networkError(request));
        }
        return sender;
    }
}

