/*
 * Decompiled with CFR 0.152.
 */
package in.srain.cube.set.hash;

import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Set;

public class SimpleHashSet<T>
extends AbstractSet<T>
implements Set<T>,
Cloneable {
    private static final int MINIMUM_CAPACITY = 4;
    private static final int MAXIMUM_CAPACITY = 0x40000000;
    private static final SimpleHashSetEntry[] EMPTY_TABLE = new SimpleHashSetEntry[2];
    transient SimpleHashSetEntry<T>[] mTable;
    transient int mSize;
    private transient int threshold;
    private SimpleHashSetEntry<T> mEntryForNull;

    public SimpleHashSet() {
        this.mTable = EMPTY_TABLE;
        this.threshold = -1;
    }

    public SimpleHashSet(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Capacity: " + capacity);
        }
        if (capacity == 0) {
            SimpleHashSetEntry[] tab = EMPTY_TABLE;
            this.mTable = tab;
            this.threshold = -1;
            return;
        }
        capacity = capacity < 4 ? 4 : (capacity > 0x40000000 ? 0x40000000 : SimpleHashSet.roundUpToPowerOfTwo(capacity));
        this.makeTable(capacity);
    }

    public SimpleHashSet(Collection<? extends T> collection) {
        this(collection.size() < 6 ? 11 : collection.size() * 2);
        for (T e : collection) {
            this.add(e);
        }
    }

    public static int roundUpToPowerOfTwo(int i) {
        --i;
        i |= i >>> 1;
        i |= i >>> 2;
        i |= i >>> 4;
        i |= i >>> 8;
        i |= i >>> 16;
        return i + 1;
    }

    public static int secondaryHash(Object key) {
        int hash = key.hashCode();
        hash ^= hash >>> 20 ^ hash >>> 12;
        hash ^= hash >>> 7 ^ hash >>> 4;
        return hash;
    }

    @Override
    public Iterator<T> iterator() {
        return new HashSetIterator();
    }

    @Override
    public int size() {
        return this.mSize;
    }

    @Override
    public boolean remove(Object key) {
        if (key == null) {
            if (this.mEntryForNull == null) {
                return false;
            }
            this.mEntryForNull = null;
            --this.mSize;
            return true;
        }
        int hash = SimpleHashSet.secondaryHash(key);
        SimpleHashSetEntry<T>[] tab = this.mTable;
        int index = hash & tab.length - 1;
        SimpleHashSetEntry e = tab[index];
        SimpleHashSetEntry prev = null;
        while (e != null) {
            if (e.mHash == hash && key.equals(e.mKey)) {
                if (prev == null) {
                    tab[index] = e.mNext;
                } else {
                    prev.mNext = e.mNext;
                }
                --this.mSize;
                return true;
            }
            prev = e;
            e = e.mNext;
        }
        return false;
    }

    @Override
    public boolean add(T key) {
        if (key == null) {
            if (this.mEntryForNull == null) {
                ++this.mSize;
                this.mEntryForNull = new SimpleHashSetEntry(0, null);
                return true;
            }
            return false;
        }
        int hash = SimpleHashSet.secondaryHash(key);
        SimpleHashSetEntry<T>[] tab = this.mTable;
        int index = hash & tab.length - 1;
        SimpleHashSetEntry e = tab[index];
        while (e != null) {
            if (e.mKey == key || e.mHash == hash && e.mKey.equals(key)) {
                return false;
            }
            e = e.mNext;
        }
        if (this.mSize++ > this.threshold) {
            tab = this.doubleCapacity();
            index = hash & tab.length - 1;
        }
        tab[index] = new SimpleHashSetEntry(hash, key);
        return true;
    }

    private SimpleHashSetEntry<T>[] makeTable(int newCapacity) {
        SimpleHashSetEntry[] newTable = new SimpleHashSetEntry[newCapacity];
        this.mTable = newTable;
        this.threshold = (newCapacity >> 1) + (newCapacity >> 2);
        return newTable;
    }

    private SimpleHashSetEntry<T>[] doubleCapacity() {
        SimpleHashSetEntry<T>[] oldTable = this.mTable;
        int oldCapacity = oldTable.length;
        if (oldCapacity == 0x40000000) {
            return oldTable;
        }
        int newCapacity = oldCapacity * 2;
        SimpleHashSetEntry<T>[] newTable = this.makeTable(newCapacity);
        if (this.mSize == 0) {
            return newTable;
        }
        for (int j = 0; j < oldCapacity; ++j) {
            SimpleHashSetEntry e = oldTable[j];
            if (e == null) continue;
            int highBit = e.mHash & oldCapacity;
            SimpleHashSetEntry broken = null;
            newTable[j | highBit] = e;
            SimpleHashSetEntry n = e.mNext;
            while (n != null) {
                int nextHighBit = n.mHash & oldCapacity;
                if (nextHighBit != highBit) {
                    if (broken == null) {
                        newTable[j | nextHighBit] = n;
                    } else {
                        broken.mNext = n;
                    }
                    broken = e;
                    highBit = nextHighBit;
                }
                e = n;
                n = n.mNext;
            }
            if (broken == null) continue;
            broken.mNext = null;
        }
        return newTable;
    }

    @Override
    public boolean contains(Object key) {
        if (key == null) {
            return this.mEntryForNull != null;
        }
        int hash = SimpleHashSet.secondaryHash(key);
        SimpleHashSetEntry<T>[] tab = this.mTable;
        SimpleHashSetEntry e = tab[hash & tab.length - 1];
        while (e != null) {
            if (e.mKey == key || e.mHash == hash && e.mKey.equals(key)) {
                return true;
            }
            e = e.mNext;
        }
        return false;
    }

    @Override
    public void clear() {
        if (this.mSize != 0) {
            Arrays.fill(this.mTable, null);
            this.mEntryForNull = null;
            this.mSize = 0;
        }
    }

    public Object clone() {
        SimpleHashSet result;
        try {
            result = (SimpleHashSet)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
        result.mEntryForNull = null;
        result.makeTable(this.mTable.length);
        result.mSize = 0;
        Iterator<T> it = this.iterator();
        while (it.hasNext()) {
            result.add(it.next());
        }
        return result;
    }

    private class HashSetIterator
    implements Iterator<T> {
        int nextIndex;
        SimpleHashSetEntry<T> nextEntry;
        SimpleHashSetEntry<T> lastEntryReturned;

        private HashSetIterator() {
            this.nextEntry = SimpleHashSet.this.mEntryForNull;
            if (SimpleHashSet.this.mEntryForNull == null) {
                SimpleHashSetEntry<T>[] tab = SimpleHashSet.this.mTable;
                SimpleHashSetEntry next = null;
                while (next == null && this.nextIndex < tab.length) {
                    next = tab[this.nextIndex++];
                }
                this.nextEntry = next;
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextEntry != null;
        }

        @Override
        public T next() {
            if (this.nextEntry == null) {
                throw new NoSuchElementException();
            }
            SimpleHashSetEntry entryToReturn = this.nextEntry;
            SimpleHashSetEntry<T>[] tab = SimpleHashSet.this.mTable;
            SimpleHashSetEntry next = entryToReturn.mNext;
            while (next == null && this.nextIndex < tab.length) {
                next = tab[this.nextIndex++];
            }
            this.nextEntry = next;
            this.lastEntryReturned = entryToReturn;
            return entryToReturn.mKey;
        }

        @Override
        public void remove() {
            if (this.lastEntryReturned == null) {
                throw new IllegalStateException();
            }
            SimpleHashSet.this.remove(this.lastEntryReturned.mKey);
            this.lastEntryReturned = null;
        }
    }

    private static class SimpleHashSetEntry<T> {
        private int mHash;
        private T mKey;
        private SimpleHashSetEntry<T> mNext;

        private SimpleHashSetEntry(int hash, T key) {
            this.mHash = hash;
            this.mKey = key;
        }
    }
}

