/*
 * Decompiled with CFR 0.152.
 */
package in.srain.cube.update;

import android.webkit.URLUtil;
import in.srain.cube.cache.DiskFileUtils;
import in.srain.cube.concurrent.SimpleTask;
import in.srain.cube.diskcache.FileUtils;
import in.srain.cube.update.DownLoadListener;
import in.srain.cube.util.CLog;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;

public class DownloadTask
extends SimpleTask {
    private static final String LOG_TAG = "cube-update";
    public static final int RESULT_OK = 1;
    public static final int RESULT_URL_ERROR = 2;
    public static final int RESULT_DOWNLOAD_ERROR = 3;
    public static final int RESULT_NO_ENOUGH_SPACE = 4;
    private int mResult = 1;
    private String mUrl;
    private String mFileName;
    private DownLoadListener mDownLoadListener;

    public DownloadTask(DownLoadListener listener, String url, String fileName) {
        this.mDownLoadListener = listener;
        this.mUrl = url;
        this.mFileName = fileName;
    }

    private void setResult(int result) {
        this.mResult = result;
    }

    @Override
    public void doInBackground() {
        if (!URLUtil.isNetworkUrl((String)this.mUrl)) {
            this.setResult(2);
            return;
        }
        String updateUrl = this.mUrl;
        int totalRead = 0;
        int totalSize = 0;
        try {
            int read;
            File dir;
            URL myURL = new URL(updateUrl);
            HttpURLConnection conn = (HttpURLConnection)myURL.openConnection();
            conn.setConnectTimeout(30000);
            conn.connect();
            totalSize = conn.getContentLength();
            File dstFile = new File(this.mFileName);
            if (dstFile.exists() && (long)totalSize == dstFile.length()) {
                if (conn != null) {
                    conn.disconnect();
                }
                this.setResult(1);
                return;
            }
            if (dstFile.exists()) {
                dstFile.delete();
            }
            if (!(dir = dstFile.getParentFile()).exists() && !dir.mkdirs()) {
                this.setResult(3);
                return;
            }
            long free = DiskFileUtils.getUsableSpace(dir);
            if (free < (long)totalSize) {
                this.setResult(4);
                return;
            }
            InputStream is = conn.getInputStream();
            if (is == null) {
                this.setResult(3);
                return;
            }
            FileOutputStream fos = new FileOutputStream(dstFile);
            byte[] buf = new byte[409200];
            while (!this.isCancelled() && (read = is.read(buf)) > 0) {
                fos.write(buf, 0, read);
                int updatePercent = (int)(100.0f * (float)(totalRead += read) / (float)totalSize);
                if (this.isCancelled()) continue;
                this.mDownLoadListener.onPercentUpdate(updatePercent);
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (conn != null) {
                conn.disconnect();
            }
        }
        catch (Exception e) {
            this.setResult(3);
            return;
        }
        if (this.isCancelled()) {
            CLog.d((String)LOG_TAG, (String)"task has been canceled");
            return;
        }
        if (totalRead != totalSize) {
            CLog.d((String)LOG_TAG, (String)"download fail, file not complete");
            this.setResult(3);
        } else {
            FileUtils.chmod("666", this.mFileName);
            this.setResult(1);
        }
    }

    @Override
    protected void onCancel() {
        this.mDownLoadListener.onCancel();
    }

    @Override
    public void onFinish(boolean canceled) {
        this.mDownLoadListener.onDone(canceled, this.mResult);
    }
}

