/*
 * Decompiled with CFR 0.152.
 */
package in.srain.cube.update;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.widget.RemoteViews;
import android.widget.Toast;
import in.srain.cube.R;
import in.srain.cube.cache.DiskFileUtils;
import in.srain.cube.update.DownLoadListener;
import in.srain.cube.update.DownloadTask;
import java.io.File;

public class UpdateController
implements DownLoadListener {
    private static final String LOG_TAG = "cube-update";
    private static final int NOTIFY_ID = 10000;
    private static final String MSG_ERROR_URL = "\u9519\u8bef\u7684\u4e0b\u8f7d\u5730\u5740";
    private static final String MSG_DOWNLOAD_FINISH_TICKER_TEXT = "\u4e0b\u8f7d\u5df2\u5b8c\u6210\uff0c\u8bf7\u5230\u7cfb\u7edf\u901a\u77e5\u680f\u67e5\u770b\u548c\u5b89\u88c5";
    private static final String MSG_DOWNLOAD_FINISH_TITLE = "\u4e0b\u8f7d\u5df2\u5b8c\u6210\uff0c\u70b9\u51fb\u5b89\u88c5";
    private static final String MSG_DOWN_LOAD_START = "\u5df2\u8f6c\u5165\u540e\u53f0\u4e0b\u8f7d\uff0c\u8bf7\u7a0d\u5019";
    private static final String MSG_DOWNLOAD_FAIL = "\u4e0b\u8f7d\u5931\u8d25";
    private static final String ACTION_CANCEL_DOWNLOAD = ".cancelDownloadApk";
    private static UpdateController sInstance;
    Notification mNotification = null;
    NotificationManager mNotifyManager = null;
    private String mDownLoadErrorMsg = "\u4e0b\u8f7d\u5931\u8d25";
    private String mPackageName;
    private DownloadTask mDownloadTask;
    private Context mContext;
    private String mActionCancel;
    private String mApkPath;
    private PackageInfo mPackageInfo;
    private int mIcon;

    private UpdateController() {
    }

    public static UpdateController getInstance() {
        if (sInstance == null) {
            sInstance = new UpdateController();
        }
        return sInstance;
    }

    public void init(Context context, int icon) {
        if (context == null) {
            throw new IllegalArgumentException("How content can be null?");
        }
        this.mContext = context;
        this.mIcon = icon;
        PackageManager manager = context.getPackageManager();
        try {
            this.mPackageInfo = manager.getPackageInfo(context.getPackageName(), 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new RuntimeException("Can not find package information");
        }
        this.mPackageName = this.mPackageInfo.packageName;
        this.mActionCancel = this.mPackageName + ACTION_CANCEL_DOWNLOAD;
        this.mNotifyManager = (NotificationManager)this.mContext.getSystemService("notification");
        this.mNotification = new Notification();
        this.mNotification.icon = this.mIcon;
        this.mNotification.flags = 16;
    }

    private void notifyDownloadFinish() {
        Intent openIntent = new Intent("android.intent.action.VIEW");
        openIntent.setFlags(0x10000000);
        openIntent.setDataAndType(Uri.fromFile((File)new File(this.mApkPath)), "application/vnd.android.package-archive");
        PendingIntent contentIntent = PendingIntent.getActivity((Context)this.mContext, (int)0, (Intent)openIntent, (int)0);
        Notification notification = new Notification();
        notification.icon = this.mIcon;
        notification.flags = 16;
        notification.contentView = new RemoteViews(this.mPackageName, R.layout.cube_mints_update_notify);
        notification.contentView.setImageViewResource(R.id.update_notification_icon, this.mIcon);
        notification.contentView.setProgressBar(R.id.update_notification_progress, 100, 100, false);
        notification.contentView.setTextViewText(R.id.update_notification_text, (CharSequence)MSG_DOWNLOAD_FINISH_TITLE);
        notification.defaults = 3;
        notification.tickerText = MSG_DOWNLOAD_FINISH_TICKER_TEXT;
        notification.contentIntent = contentIntent;
        this.mNotifyManager.notify(10000, notification);
        this.openFile();
    }

    private void notifyDownLoadStart() {
        this.showToastMessage(MSG_DOWN_LOAD_START);
        RemoteViews contentView = new RemoteViews(this.mPackageName, R.layout.cube_mints_update_notify);
        this.mNotification.icon = this.mIcon;
        this.mNotification.tickerText = MSG_DOWN_LOAD_START;
        this.mNotification.contentView = contentView;
        this.mNotification.contentView.setProgressBar(R.id.update_notification_progress, 100, 0, false);
        this.mNotification.contentView.setImageViewResource(R.id.update_notification_icon, this.mIcon);
        this.mNotifyManager.notify(10000, this.mNotification);
    }

    private void notifyDownLoading(int updatePercent) {
        Intent intent = new Intent(this.mActionCancel);
        PendingIntent contentIntent = PendingIntent.getBroadcast((Context)this.mContext, (int)0, (Intent)intent, (int)0);
        this.mNotification.contentView = new RemoteViews(this.mPackageName, R.layout.cube_mints_update_notify);
        this.mNotification.contentView.setImageViewResource(R.id.update_notification_icon, this.mIcon);
        this.mNotification.contentView.setProgressBar(R.id.update_notification_progress, 100, updatePercent, false);
        this.mNotification.contentView.setTextViewText(R.id.update_notification_text, (CharSequence)("\u4e0b\u8f7d\u8fdb\u5ea6  " + updatePercent + "%, \u70b9\u51fb\u53d6\u6d88\u4e0b\u8f7d"));
        this.mNotification.contentView.setOnClickPendingIntent(R.id.update_notification_layout, contentIntent);
        this.mNotifyManager.notify(10000, this.mNotification);
    }

    public void beginDownLoad(String url) {
        String dir = DiskFileUtils.wantFilesPath(this.mContext, true);
        String fileName = url.substring(url.lastIndexOf("/") + 1);
        this.mApkPath = dir + File.separator + "downloads" + File.separator + fileName;
        this.mDownloadTask = new DownloadTask(this, url, this.mApkPath);
        this.notifyDownLoadStart();
        IntentFilter filter = new IntentFilter();
        filter.addAction(this.mActionCancel);
        this.mContext.registerReceiver((BroadcastReceiver)new CancelBroadcastReceiver(), filter);
        Thread thread = new Thread(this.mDownloadTask);
        thread.setDaemon(true);
        thread.start();
    }

    private void openFile() {
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.setFlags(0x10000000);
        intent.setDataAndType(Uri.fromFile((File)new File(this.mApkPath)), "application/vnd.android.package-archive");
        this.mContext.startActivity(intent);
        this.mNotifyManager.cancel(10000);
    }

    @Override
    public void onCancel() {
    }

    @Override
    public void onDone(boolean canceled, int result) {
        if (canceled) {
            return;
        }
        switch (result) {
            case 1: {
                this.notifyDownloadFinish();
                break;
            }
            case 3: {
                this.mNotifyManager.cancel(10000);
                this.deleteApkFile();
                this.showToastMessage(this.mDownLoadErrorMsg);
                break;
            }
            case 4: {
                break;
            }
            case 2: {
                this.mNotifyManager.cancel(10000);
                this.deleteApkFile();
                this.showToastMessage(MSG_ERROR_URL);
            }
        }
    }

    @Override
    public void onPercentUpdate(int percent) {
        this.notifyDownLoading(percent);
    }

    private void deleteApkFile() {
    }

    private void showToastMessage(String msg) {
        Toast toast = Toast.makeText((Context)this.mContext, (CharSequence)msg, (int)5000);
        toast.setGravity(17, 0, 0);
        toast.show();
    }

    private class CancelBroadcastReceiver
    extends BroadcastReceiver {
        private CancelBroadcastReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            UpdateController.this.mNotifyManager.cancel(10000);
            UpdateController.this.mDownloadTask.cancel();
        }
    }
}

