/*
 * Decompiled with CFR 0.152.
 */
package in.srain.cube.uri;

import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import in.srain.cube.request.JsonData;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.Iterator;

public class CustomizedUri {
    private static final String KEY = "CUBE_URL";
    private static final String[] PUB_SCHEMA_LIST = new String[]{"http://", "https://"};
    private JsonData mQueryData = JsonData.newMap();
    private String mSchemaPre = null;
    private String mPath = null;
    private String mQuery = null;
    private String mOriginUrl = null;
    private boolean mIsCustomized;

    public String getPath() {
        return this.mPath;
    }

    public boolean isCustomized() {
        return this.mIsCustomized;
    }

    public String getQueryString() {
        return this.mQuery;
    }

    public JsonData getQueryData() {
        return this.mQueryData;
    }

    public String getOriginUrl() {
        return this.mOriginUrl;
    }

    public static CustomizedUri parse(String url, String customizedSchema) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            throw new RuntimeException("url is null");
        }
        if (url.startsWith(customizedSchema)) {
            CustomizedUri uri = new CustomizedUri(url, customizedSchema);
            uri.mIsCustomized = true;
            return uri;
        }
        for (int i = 0; i < PUB_SCHEMA_LIST.length; ++i) {
            String schema = PUB_SCHEMA_LIST[i];
            if (!url.startsWith(schema)) continue;
            return new CustomizedUri(url, schema);
        }
        return null;
    }

    public void writeToBundle(Intent intent) {
        intent.putExtra(KEY, this.buildUrl());
    }

    private static String decode(String content, String encoding) {
        try {
            return URLDecoder.decode(content, encoding != null ? encoding : "ISO-8859-1");
        }
        catch (UnsupportedEncodingException var3) {
            throw new IllegalArgumentException(var3);
        }
    }

    private String buildUrl() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.mSchemaPre).append(this.mPath);
        if (this.mQueryData != null && this.mQueryData.length() > 0) {
            sb.append("?");
            Iterator<String> names = this.mQueryData.keys();
            boolean first = true;
            while (names.hasNext()) {
                String encodedValue;
                String name = names.next();
                String encodedName = Uri.encode((String)name);
                String value = this.mQueryData.optString(name);
                String string2 = encodedValue = value != null ? Uri.encode((String)value) : "";
                if (first) {
                    first = false;
                } else {
                    sb.append("&");
                }
                sb.append(encodedName);
                sb.append("=");
                sb.append(encodedValue);
            }
        }
        return sb.toString();
    }

    public static CustomizedUri fromIntent(Intent intent, String schema) {
        if (intent == null) {
            return null;
        }
        String url = intent.getStringExtra(KEY);
        if (TextUtils.isEmpty((CharSequence)url)) {
            return null;
        }
        return CustomizedUri.parse(url, schema);
    }

    private CustomizedUri(String url, String schemaPre) {
        int pos_sp;
        this.mSchemaPre = schemaPre;
        this.mOriginUrl = url;
        int pos_seg = url.indexOf(35);
        if (pos_seg > 0) {
            url = url.substring(0, pos_seg);
        }
        if ((pos_sp = url.indexOf(63)) > 0) {
            this.mQuery = url.substring(pos_sp + 1);
            url = url.substring(0, pos_sp);
        }
        this.mPath = url.substring(schemaPre.length());
        if (!TextUtils.isEmpty((CharSequence)this.mQuery)) {
            this.parseQuery();
        }
    }

    private void parseQuery() {
        this.mQueryData = JsonData.newMap();
        String query = this.mQuery;
        int start = 0;
        while (true) {
            int nextAmpersand;
            int end = (nextAmpersand = query.indexOf(38, start)) != -1 ? nextAmpersand : query.length();
            int separator = query.indexOf(61, start);
            if (separator > end || separator == -1) break;
            if (separator != start) {
                this.mQueryData.put(Uri.decode((String)query.substring(start, separator)), (Object)Uri.decode((String)query.substring(separator + 1, end)));
            }
            if (nextAmpersand == -1) break;
            start = nextAmpersand + 1;
        }
    }
}

