/*
 * Decompiled with CFR 0.152.
 */
package in.srain.cube.util;

public class HandlerHolder<T> {
    private T mHandler;
    private HandlerHolder mNext;

    private boolean contains(T handler) {
        return this.mHandler != null && this.mHandler == handler;
    }

    private HandlerHolder() {
    }

    public boolean hasHandler() {
        return this.mHandler != null;
    }

    private T getHandler() {
        return this.mHandler;
    }

    public static <T> void addHandler(HandlerHolder head, T handler) {
        if (null == handler) {
            return;
        }
        if (head == null) {
            return;
        }
        if (null == head.mHandler) {
            head.mHandler = handler;
            return;
        }
        HandlerHolder current = head;
        while (true) {
            if (current.contains(handler)) {
                return;
            }
            if (current.mNext == null) break;
            current = current.mNext;
        }
        HandlerHolder<T> newHolder = new HandlerHolder<T>();
        newHolder.mHandler = handler;
        current.mNext = newHolder;
    }

    public static HandlerHolder create() {
        return new HandlerHolder();
    }

    public static <T> HandlerHolder removeHandler(HandlerHolder head, T handler) {
        if (head == null || handler == null || null == head.mHandler) {
            return head;
        }
        HandlerHolder<T> current = head;
        HandlerHolder<T> pre = null;
        do {
            if (current.contains(handler)) {
                if (pre == null) {
                    head = current.mNext;
                    current.mNext = null;
                    current = head;
                    continue;
                }
                pre.mNext = current.mNext;
                current.mNext = null;
                current = pre.mNext;
                continue;
            }
            pre = current;
            current = current.mNext;
        } while (current != null);
        if (head == null) {
            head = new HandlerHolder<T>();
        }
        return head;
    }
}

