/*
 * Decompiled with CFR 0.152.
 */
package in.srain.cube.views;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.PointF;
import android.util.AttributeSet;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import in.srain.cube.R;
import in.srain.cube.util.CLog;
import in.srain.cube.util.CubeDebug;
import in.srain.cube.views.IScrollHeaderFrameHandler;

public class ScrollHeaderFrame
extends RelativeLayout {
    private static final boolean DEBUG = CubeDebug.DEBUG_SCROLL_HEADER_FRAME;
    private static final String LOG_TAG = ScrollHeaderFrame.class.getName();
    private int mHeaderHeight;
    private int mCurrentPos = 0;
    private int mLastPos = 0;
    private int mHeaderId = 0;
    private int mContainerId = 0;
    private boolean mDisabled = false;
    private ViewGroup mContentViewContainer;
    private View mHeaderContainer;
    private long mLastTime;
    private PointF mPtLastMove = new PointF();
    private IScrollHeaderFrameHandler mIScrollHeaderFrameHandler;

    public ScrollHeaderFrame(Context context) {
        this(context, null);
    }

    public ScrollHeaderFrame(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public ScrollHeaderFrame(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        TypedArray arr = context.obtainStyledAttributes(attrs, R.styleable.ScrollHeaderFrame, 0, 0);
        if (arr != null) {
            if (arr.hasValue(0)) {
                this.mHeaderId = arr.getResourceId(0, 0);
            }
            if (arr.hasValue(1)) {
                this.mContainerId = arr.getResourceId(1, 0);
            }
            if (arr.hasValue(3)) {
                this.mDisabled = arr.getBoolean(3, false);
            }
            arr.recycle();
        }
    }

    public View getContentView() {
        return this.mContentViewContainer;
    }

    public View getHeaderView() {
        return this.mHeaderContainer;
    }

    public void setHandler(IScrollHeaderFrameHandler handler) {
        this.mIScrollHeaderFrameHandler = handler;
        CLog.d((String)LOG_TAG, (String)"setHandler: %s", (Object[])new Object[]{this});
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.mHeaderContainer = this.findViewById(this.mHeaderId);
        this.mContentViewContainer = (ViewGroup)this.findViewById(this.mContainerId);
        this.setDrawingCacheEnabled(false);
        this.setBackgroundDrawable(null);
        this.setClipChildren(false);
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int headerHeight;
        super.onLayout(changed, l, t, r, b);
        if (DEBUG) {
            Log.d((String)LOG_TAG, (String)String.format("onLayout: current %s, %s %s %s %s", this.mCurrentPos, l, t, r, b));
        }
        if ((headerHeight = this.mHeaderContainer.getMeasuredHeight()) == 0) {
            return;
        }
        int w = this.getMeasuredWidth();
        int h = this.getMeasuredHeight();
        int pos = 0;
        this.mHeaderContainer.layout(0, pos, w, pos + headerHeight);
        this.mContentViewContainer.layout(0, pos + headerHeight, w, h + headerHeight);
    }

    private boolean tryToMove(float deltaY) {
        if (deltaY > 0.0f && this.mCurrentPos == 0) {
            if (DEBUG) {
                Log.d((String)LOG_TAG, (String)String.format("has reached the bottom", new Object[0]));
            }
            return false;
        }
        if (deltaY < 0.0f && this.mCurrentPos == -this.mHeaderHeight) {
            if (DEBUG) {
                Log.d((String)LOG_TAG, (String)String.format("has reached the top", new Object[0]));
            }
            return false;
        }
        int to = this.mCurrentPos + (int)deltaY;
        if (to < -this.mHeaderHeight) {
            if (DEBUG) {
                Log.d((String)LOG_TAG, (String)String.format("over top", new Object[0]));
            }
            to = -this.mHeaderHeight;
        }
        if (to > 0) {
            if (DEBUG) {
                Log.d((String)LOG_TAG, (String)String.format("over bottom", new Object[0]));
            }
            to = 0;
        }
        return this.moveTo(to);
    }

    private boolean moveTo(int to) {
        if (DEBUG) {
            Log.d((String)LOG_TAG, (String)String.format("moveTo: %s %s, %s", to, this.mCurrentPos, this.mHeaderHeight));
        }
        if (this.mCurrentPos == to) {
            return false;
        }
        int y = this.mCurrentPos - to;
        this.mCurrentPos = to;
        this.updatePos();
        return true;
    }

    private void updatePos() {
        int change = this.mCurrentPos - this.mLastPos;
        this.scrollTo(0, -change);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        int w = this.getMeasuredWidth();
        int h = this.getMeasuredHeight();
        this.mHeaderHeight = this.mHeaderContainer.getMeasuredHeight();
        if (DEBUG) {
            Log.d((String)LOG_TAG, (String)String.format("onMeasure %s getMeasuredHeight: %s", h, this.mHeaderContainer.getMeasuredHeight()));
        }
        this.mContentViewContainer.measure(View.MeasureSpec.makeMeasureSpec((int)w, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)h, (int)Integer.MIN_VALUE));
    }

    public boolean dispatchTouchEvent(MotionEvent e) {
        if (!this.isEnabled() || this.mDisabled) {
            return super.dispatchTouchEvent(e);
        }
        boolean handled = super.dispatchTouchEvent(e);
        int action = e.getAction();
        switch (action) {
            case 1: {
                break;
            }
            case 3: {
                break;
            }
            case 0: {
                this.mLastTime = e.getEventTime();
                this.mPtLastMove.set(e.getX(), e.getY());
                break;
            }
            case 2: {
                boolean canMoveDown;
                if (this.mHeaderHeight == 0) break;
                float deltaY = (int)(e.getY() - this.mPtLastMove.y);
                this.mPtLastMove.set(e.getX(), e.getY());
                float speed = Math.abs(deltaY / (float)(this.mLastTime - e.getEventTime()));
                this.mLastTime = e.getEventTime();
                boolean moveUp = deltaY < 0.0f;
                boolean canMoveUp = this.mCurrentPos > -this.mHeaderHeight;
                boolean moveDown = !moveUp;
                boolean bl = canMoveDown = this.mCurrentPos < 0;
                if (DEBUG) {
                    Log.d((String)LOG_TAG, (String)String.format("ACTION_MOVE: %s, speed: %s, moveUp: %s, canMoveUp: %s, moveDown: %s, canMoveDown: %s", Float.valueOf(speed), Float.valueOf(deltaY), moveUp, canMoveUp, moveDown, canMoveDown));
                }
                if (moveDown && this.mIScrollHeaderFrameHandler != null && !this.mIScrollHeaderFrameHandler.hasReachTop()) {
                    return handled;
                }
                if (speed >= 5.0f && moveDown && this.mIScrollHeaderFrameHandler != null) {
                    this.moveTo(0);
                    return handled;
                }
                if (speed >= 5.0f && moveUp && this.mIScrollHeaderFrameHandler != null) {
                    this.moveTo(-this.mHeaderHeight);
                    return handled;
                }
                if ((!moveUp || !canMoveUp) && (!moveDown || !canMoveDown)) break;
                this.tryToMove(deltaY);
                break;
            }
        }
        return handled;
    }
}

