/*
 * Decompiled with CFR 0.152.
 */
package in.srain.cube.views.banner;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.v4.view.PagerAdapter;
import android.support.v4.view.ViewPager;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.widget.RelativeLayout;
import in.srain.cube.R;
import in.srain.cube.views.DotView;
import in.srain.cube.views.banner.BannerAdapter;
import in.srain.cube.views.banner.PagerIndicator;
import in.srain.cube.views.mix.AutoPlayer;

public class SliderBanner
extends RelativeLayout {
    protected int mIdForViewPager;
    protected int mIdForIndicator;
    protected int mTimeInterval = 2000;
    private ViewPager mViewPager;
    private BannerAdapter mBannerAdapter;
    private ViewPager.OnPageChangeListener mOnPageChangeListener;
    private PagerIndicator mPagerIndicator;
    private AutoPlayer mAutoPlayer;
    private View.OnTouchListener mViewPagerOnTouchListener;
    private AutoPlayer.Playable mGalleryPlayable = new AutoPlayer.Playable(){

        @Override
        public void playTo(int to) {
            SliderBanner.this.mViewPager.setCurrentItem(to, true);
        }

        @Override
        public void playNext() {
            SliderBanner.this.mViewPager.setCurrentItem(SliderBanner.this.mViewPager.getCurrentItem() + 1, true);
        }

        @Override
        public void playPrevious() {
            SliderBanner.this.mViewPager.setCurrentItem(SliderBanner.this.mViewPager.getCurrentItem() - 1, true);
        }

        @Override
        public int getTotal() {
            return SliderBanner.this.mBannerAdapter.getCount();
        }

        @Override
        public int getCurrent() {
            return SliderBanner.this.mViewPager.getCurrentItem();
        }
    };

    public SliderBanner(Context context) {
        this(context, null);
    }

    public SliderBanner(Context context, AttributeSet attrs) {
        super(context, attrs);
        TypedArray arr = context.obtainStyledAttributes(attrs, R.styleable.SliderBanner, 0, 0);
        if (arr != null) {
            if (arr.hasValue(1)) {
                this.mIdForViewPager = arr.getResourceId(1, 0);
            }
            if (arr.hasValue(0)) {
                this.mIdForIndicator = arr.getResourceId(0, 0);
            }
            this.mTimeInterval = arr.getInt(2, this.mTimeInterval);
            arr.recycle();
        }
    }

    public boolean dispatchTouchEvent(MotionEvent ev) {
        int action = ev.getAction();
        switch (action) {
            case 0: {
                if (this.mAutoPlayer == null) break;
                this.mAutoPlayer.pause();
                break;
            }
            case 1: 
            case 3: {
                if (this.mAutoPlayer == null) break;
                this.mAutoPlayer.resume();
                break;
            }
        }
        if (this.mViewPagerOnTouchListener != null) {
            this.mViewPagerOnTouchListener.onTouch((View)this, ev);
        }
        return super.dispatchTouchEvent(ev);
    }

    public void setViewPagerOnTouchListener(View.OnTouchListener onTouchListener) {
        this.mViewPagerOnTouchListener = onTouchListener;
    }

    protected void onFinishInflate() {
        this.mViewPager = (ViewPager)this.findViewById(this.mIdForViewPager);
        this.mPagerIndicator = (DotView)this.findViewById(this.mIdForIndicator);
        this.mViewPager.setOnPageChangeListener(new ViewPager.OnPageChangeListener(){

            public void onPageScrolled(int i, float v, int i2) {
                if (SliderBanner.this.mOnPageChangeListener != null) {
                    SliderBanner.this.mOnPageChangeListener.onPageScrolled(i, v, i2);
                }
            }

            public void onPageSelected(int position) {
                if (SliderBanner.this.mPagerIndicator != null) {
                    SliderBanner.this.mPagerIndicator.setSelected(SliderBanner.this.mBannerAdapter.getPositionForIndicator(position));
                }
                SliderBanner.this.mAutoPlayer.skipNext();
                if (SliderBanner.this.mOnPageChangeListener != null) {
                    SliderBanner.this.mOnPageChangeListener.onPageSelected(position);
                }
            }

            public void onPageScrollStateChanged(int i) {
                if (SliderBanner.this.mOnPageChangeListener != null) {
                    SliderBanner.this.mOnPageChangeListener.onPageScrollStateChanged(i);
                }
            }
        });
        this.mAutoPlayer = new AutoPlayer(this.mGalleryPlayable).setPlayRecycleMode(AutoPlayer.PlayRecycleMode.play_back);
        this.mAutoPlayer.setTimeInterval(this.mTimeInterval);
    }

    public void setTimeInterval(int interval) {
        this.mAutoPlayer.setTimeInterval(interval);
    }

    public void setAdapter(BannerAdapter adapter) {
        this.mBannerAdapter = adapter;
        this.mViewPager.setAdapter((PagerAdapter)adapter);
    }

    public void beginPlay() {
        this.mAutoPlayer.play();
    }

    public void setOnPageChangeListener(ViewPager.OnPageChangeListener listener) {
        this.mOnPageChangeListener = listener;
    }

    public void setDotNum(int num) {
        if (this.mPagerIndicator != null) {
            this.mPagerIndicator.setNum(num);
        }
    }
}

