/*
 * Decompiled with CFR 0.152.
 */
package in.srain.cube.views.block;

import android.view.LayoutInflater;
import android.view.View;
import in.srain.cube.views.block.BlockListView;
import java.util.List;

public abstract class BlockListAdapter<T> {
    private List<T> mItemList;
    private BlockListView mView;
    private int mBlockWidth = -2;
    private int mBlockHeight = -2;
    private int mWidthSpace = 0;
    private int mHeightSpace = 0;
    private int mColumnNum = 0;

    public T getItem(int position) {
        return this.mItemList.get(position);
    }

    public void registerView(BlockListView observer) {
        this.mView = observer;
    }

    public void displayBlocks(List<T> itemList) {
        if (null == itemList) {
            return;
        }
        this.mItemList = itemList;
        if (null == this.mView) {
            throw new IllegalArgumentException("Adapter has not been attached to any BlockListView");
        }
        this.mView.onDataListChange();
    }

    public abstract View getView(LayoutInflater var1, int var2);

    public int getCount() {
        return this.mItemList.size();
    }

    public void setSpace(int w, int h) {
        this.mWidthSpace = w;
        this.mHeightSpace = h;
    }

    public int getHorizontalSpacing() {
        return this.mWidthSpace;
    }

    public int getVerticalSpacing() {
        return this.mHeightSpace;
    }

    public void setBlockSize(int w, int h) {
        this.mBlockWidth = w;
        this.mBlockHeight = h;
    }

    public int getBlockWidth() {
        return this.mBlockWidth;
    }

    public int getBlockHeight() {
        return this.mBlockHeight;
    }

    public void setColumnNum(int num) {
        this.mColumnNum = num;
    }

    public int getCloumnNum() {
        return this.mColumnNum;
    }
}

