/*
 * Decompiled with CFR 0.152.
 */
package in.srain.cube.views.block;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import in.srain.cube.views.block.BlockListAdapter;

public class BlockListView
extends RelativeLayout {
    private static final int INDEX_TAG = 0x4000000;
    private BlockListAdapter<?> mBlockListAdapter;
    private LayoutInflater mLayoutInflater;
    private OnItemClickListener mOnItemClickListener;
    View.OnClickListener mOnClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            int index = (Integer)v.getTag(0x4000000);
            if (null != BlockListView.this.mOnItemClickListener) {
                BlockListView.this.mOnItemClickListener.onItemClick(v, index);
            }
        }
    };

    public BlockListView(Context context) {
        this(context, null, 0);
    }

    public BlockListView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public BlockListView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.mLayoutInflater = LayoutInflater.from((Context)context);
    }

    public void setAdapter(BlockListAdapter<?> adapter) {
        if (adapter == null) {
            throw new IllegalArgumentException("adapter should not be null");
        }
        this.mBlockListAdapter = adapter;
        adapter.registerView(this);
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (null != this.mBlockListAdapter) {
            this.mBlockListAdapter.registerView(null);
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (null != this.mBlockListAdapter) {
            this.mBlockListAdapter.registerView(this);
        }
    }

    public void setOnItemClickListener(OnItemClickListener listener) {
        this.mOnItemClickListener = listener;
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        super.onLayout(changed, l, t, r, b);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    public void onDataListChange() {
        this.removeAllViews();
        int len = this.mBlockListAdapter.getCount();
        int w = this.mBlockListAdapter.getBlockWidth();
        int h = this.mBlockListAdapter.getBlockHeight();
        int columnNum = this.mBlockListAdapter.getCloumnNum();
        int horizontalSpacing = this.mBlockListAdapter.getHorizontalSpacing();
        int verticalSpacing = this.mBlockListAdapter.getVerticalSpacing();
        boolean blockDescendant = this.getDescendantFocusability() == 393216;
        for (int i = 0; i < len; ++i) {
            RelativeLayout.LayoutParams lyp = new RelativeLayout.LayoutParams(w, h);
            int row = i / columnNum;
            int clo = i % columnNum;
            int left = 0;
            int top = 0;
            if (clo > 0) {
                left = (horizontalSpacing + w) * clo;
            }
            if (row > 0) {
                top = (verticalSpacing + h) * row;
            }
            lyp.setMargins(left, top, 0, 0);
            View view = this.mBlockListAdapter.getView(this.mLayoutInflater, i);
            if (!blockDescendant) {
                view.setOnClickListener(this.mOnClickListener);
            }
            view.setTag(0x4000000, (Object)i);
            this.addView(view, (ViewGroup.LayoutParams)lyp);
        }
        this.requestLayout();
    }

    public static interface OnItemClickListener {
        public void onItemClick(View var1, int var2);
    }
}

