/*
 * Decompiled with CFR 0.152.
 */
package in.srain.cube.views.list;

import in.srain.cube.views.list.ViewHolderBase;
import in.srain.cube.views.list.ViewHolderCreator;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;

public class LazyViewHolderCreator<T>
implements ViewHolderCreator<T> {
    private final Constructor<?> mConstructor;
    private Object[] mInstanceObjects;

    private LazyViewHolderCreator(Constructor<?> constructor, Object[] instanceObjects) {
        this.mConstructor = constructor;
        this.mInstanceObjects = instanceObjects;
    }

    public static <ItemDataType> ViewHolderCreator<ItemDataType> create(Object enclosingInstance, Class<?> cls, Object ... args) {
        if (cls == null) {
            throw new IllegalArgumentException("ViewHolderClass is null.");
        }
        boolean isEnclosingInstanceClass = false;
        if (cls.getEnclosingClass() != null && !Modifier.isStatic(cls.getModifiers())) {
            isEnclosingInstanceClass = true;
        }
        int argsLen = isEnclosingInstanceClass ? args.length + 1 : args.length;
        Object[] instanceObjects = new Object[argsLen];
        int copyStart = 0;
        if (isEnclosingInstanceClass) {
            instanceObjects[0] = enclosingInstance;
            copyStart = 1;
        }
        if (args.length > 0) {
            System.arraycopy(args, 0, instanceObjects, copyStart, args.length);
        }
        Class[] parameterTypes = new Class[argsLen];
        for (int i = 0; i < instanceObjects.length; ++i) {
            parameterTypes[i] = instanceObjects[i].getClass();
        }
        Constructor<?> constructor = null;
        try {
            constructor = cls.getDeclaredConstructor(parameterTypes);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        if (constructor == null) {
            throw new IllegalArgumentException("ViewHolderClass can not be initiated");
        }
        LazyViewHolderCreator lazyCreator = new LazyViewHolderCreator(constructor, instanceObjects);
        return lazyCreator;
    }

    @Override
    public ViewHolderBase<T> createViewHolder() {
        Object object = null;
        try {
            boolean isAccessible = this.mConstructor.isAccessible();
            if (!isAccessible) {
                this.mConstructor.setAccessible(true);
            }
            object = this.mConstructor.newInstance(this.mInstanceObjects);
            if (!isAccessible) {
                this.mConstructor.setAccessible(false);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (object == null || !(object instanceof ViewHolderBase)) {
            throw new IllegalArgumentException("ViewHolderClass can not be initiated");
        }
        return object;
    }
}

