/*
 * Decompiled with CFR 0.152.
 */
package in.srain.cube.views.list;

import java.util.ArrayList;
import java.util.List;

public class ListPageInfo<T> {
    private int mNumPerPage = 0;
    private int mStart = 0;
    private boolean mHasMore;
    private boolean mIsBusy = false;
    private List<T> mDataList;

    public ListPageInfo(int numPerPage) {
        this.mNumPerPage = numPerPage;
    }

    public void updateListInfo(List<T> dataList, int total) {
        this.addMore(dataList);
        this.mHasMore = this.mDataList.size() < total;
        this.mIsBusy = false;
    }

    private void addMore(List<T> dataList) {
        if (dataList == null) {
            return;
        }
        if (this.mStart == 0 || this.mDataList == null) {
            this.mDataList = new ArrayList<T>();
        }
        this.mDataList.addAll(dataList);
    }

    public void updateListInfo(List<T> dataList, boolean hasMore) {
        this.addMore(dataList);
        this.mHasMore = hasMore;
        this.mIsBusy = false;
    }

    public void unlock() {
        this.mIsBusy = false;
    }

    public boolean tryEnterLock() {
        if (this.mIsBusy) {
            return false;
        }
        this.mIsBusy = true;
        return true;
    }

    public int getStart() {
        return this.mStart;
    }

    public int getNumPerPage() {
        return this.mNumPerPage;
    }

    public int getPage() {
        return this.mStart / this.mNumPerPage;
    }

    public void goToHead() {
        this.mStart = 0;
    }

    public T getItem(int position) {
        if (null == this.mDataList || position < 0 || position > this.mDataList.size()) {
            return null;
        }
        return this.mDataList.get(position);
    }

    public boolean isEmpty() {
        return this.mDataList == null || this.mDataList.size() == 0;
    }

    public boolean nextPage() {
        if (this.hasMore()) {
            this.mStart += this.mNumPerPage;
            return true;
        }
        return false;
    }

    public List<T> getDataList() {
        return this.mDataList;
    }

    public int getListLength() {
        if (this.mDataList == null) {
            return 0;
        }
        return this.mDataList.size();
    }

    public T firstItem() {
        if (this.mDataList == null || this.mDataList.size() == 0) {
            return null;
        }
        return this.mDataList.get(0);
    }

    public T lastItem() {
        if (this.mDataList == null || this.mDataList.size() == 0) {
            return null;
        }
        return this.mDataList.get(this.mDataList.size() - 1);
    }

    public boolean hasMore() {
        return this.mDataList == null || this.mHasMore;
    }

    public boolean isFirstPage() {
        return 0 == this.mStart;
    }
}

