/*
 * Decompiled with CFR 0.152.
 */
package in.srain.cube.views.list;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import in.srain.cube.util.CLog;
import in.srain.cube.util.CubeDebug;
import in.srain.cube.views.list.LazyViewHolderCreator;
import in.srain.cube.views.list.ViewHolderBase;
import in.srain.cube.views.list.ViewHolderCreator;

public abstract class ListViewDataAdapterBase<ItemDataType>
extends BaseAdapter {
    private static final String LOG_TAG = "cube-list";
    protected ViewHolderCreator<ItemDataType> mViewHolderCreator;
    protected ViewHolderCreator<ItemDataType> mLazyCreator;
    protected boolean mForceCreateView = false;

    public ListViewDataAdapterBase() {
    }

    public ListViewDataAdapterBase(Object enclosingInstance, Class<?> cls) {
        this.setViewHolderClass(enclosingInstance, cls, new Object[0]);
    }

    public ListViewDataAdapterBase(ViewHolderCreator<ItemDataType> viewHolderCreator) {
        this.mViewHolderCreator = viewHolderCreator;
    }

    public void setViewHolderCreator(ViewHolderCreator<ItemDataType> viewHolderCreator) {
        this.mViewHolderCreator = viewHolderCreator;
    }

    public void setViewHolderClass(Object enclosingInstance, Class<?> cls, Object ... args) {
        this.mLazyCreator = LazyViewHolderCreator.create(enclosingInstance, cls, args);
    }

    private ViewHolderBase<ItemDataType> createViewHolder() {
        if (this.mViewHolderCreator == null && this.mLazyCreator == null) {
            throw new RuntimeException("view holder creator is null");
        }
        if (this.mViewHolderCreator != null) {
            return this.mViewHolderCreator.createViewHolder();
        }
        if (this.mLazyCreator != null) {
            return this.mLazyCreator.createViewHolder();
        }
        return null;
    }

    public void forceCreateView(boolean yes) {
        this.mForceCreateView = yes;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        if (CubeDebug.DEBUG_LIST) {
            CLog.d((String)LOG_TAG, (String)"getView %s", (Object[])new Object[]{position});
        }
        ItemDataType itemData = this.getItem(position);
        ViewHolderBase holderBase = null;
        if (this.mForceCreateView || convertView == null || !(convertView.getTag() instanceof ViewHolderBase)) {
            LayoutInflater inflater = LayoutInflater.from((Context)parent.getContext());
            holderBase = this.createViewHolder();
            if (holderBase != null && (convertView = holderBase.createView(inflater)) != null && !this.mForceCreateView) {
                convertView.setTag((Object)holderBase);
            }
        } else {
            holderBase = (ViewHolderBase)convertView.getTag();
        }
        if (holderBase != null) {
            holderBase.setItemData(position, convertView);
            holderBase.showData(position, itemData);
        }
        return convertView;
    }

    public abstract ItemDataType getItem(int var1);
}

