/*
 * Decompiled with CFR 0.152.
 */
package in.srain.cube.views.list;

import in.srain.cube.views.list.ListPageInfo;
import java.util.List;

public abstract class PagedListDataModel<T> {
    protected ListPageInfo<T> mListPageInfo;
    private PagedListDataHandler mPagedListDataHandler;

    protected abstract void doQueryData();

    public void setPageListDataHandler(PagedListDataHandler handler) {
        this.mPagedListDataHandler = handler;
    }

    public void queryFirstPage() {
        this.checkPageInfo();
        this.mListPageInfo.goToHead();
        this.doQueryDataInner();
    }

    public void queryNextPage() {
        this.checkPageInfo();
        if (this.mListPageInfo.nextPage()) {
            this.doQueryDataInner();
        }
    }

    private void checkPageInfo() {
        if (null == this.mListPageInfo) {
            throw new IllegalArgumentException(" mListPageInfo has not been initialized.");
        }
    }

    private void doQueryDataInner() {
        if (!this.mListPageInfo.tryEnterLock()) {
            return;
        }
        this.doQueryData();
    }

    protected void setRequestResult(List<T> list, int total) {
        this.mListPageInfo.updateListInfo(list, total);
        if (null != this.mPagedListDataHandler) {
            this.mPagedListDataHandler.onPageDataLoaded(this.mListPageInfo);
        }
    }

    protected void setRequestFail() {
        this.mListPageInfo.unlock();
    }

    protected void setRequestResult(List<T> list, boolean hasMore) {
        this.mListPageInfo.updateListInfo(list, hasMore);
        if (null != this.mPagedListDataHandler) {
            this.mPagedListDataHandler.onPageDataLoaded(this.mListPageInfo);
        }
    }

    public ListPageInfo<T> getListPageInfo() {
        return this.mListPageInfo;
    }

    public static interface PagedListDataHandler {
        public void onPageDataLoaded(ListPageInfo<?> var1);
    }
}

