/*
 * Decompiled with CFR 0.152.
 */
package in.srain.cube.views.loadmore;

import android.content.Context;
import android.util.AttributeSet;
import android.view.View;
import android.widget.AbsListView;
import android.widget.LinearLayout;
import in.srain.cube.views.loadmore.LoadMoreContainer;
import in.srain.cube.views.loadmore.LoadMoreDefaultFooterView;
import in.srain.cube.views.loadmore.LoadMoreHandler;
import in.srain.cube.views.loadmore.LoadMoreUIHandler;

public abstract class LoadMoreContainerBase
extends LinearLayout
implements LoadMoreContainer {
    private AbsListView.OnScrollListener mOnScrollListener;
    private LoadMoreUIHandler mLoadMoreUIHandler;
    private LoadMoreHandler mLoadMoreHandler;
    private boolean mIsLoading;
    private boolean mHasMore = true;
    private boolean mAutoLoadMore = true;
    private boolean mShowLoadingForFirstPage = true;
    private View mFooterView;
    private AbsListView mAbsListView;
    private boolean mListEmpty = true;

    public LoadMoreContainerBase(Context context) {
        super(context);
    }

    public LoadMoreContainerBase(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.mAbsListView = this.retrieveAbsListView();
        this.init();
    }

    public void useDefaultHeader() {
        LoadMoreDefaultFooterView footerView = new LoadMoreDefaultFooterView(this.getContext());
        footerView.setVisibility(8);
        this.setLoadMoreView((View)footerView);
        this.setLoadMoreUIHandler(footerView);
    }

    private void init() {
        if (this.mFooterView != null) {
            this.addFooterView(this.mFooterView);
        }
        this.mAbsListView.setOnScrollListener(new AbsListView.OnScrollListener(){
            private boolean mIsEnd = false;

            public void onScrollStateChanged(AbsListView view, int scrollState) {
                if (null != LoadMoreContainerBase.this.mOnScrollListener) {
                    LoadMoreContainerBase.this.mOnScrollListener.onScrollStateChanged(view, scrollState);
                }
                if (scrollState == 0 && this.mIsEnd) {
                    LoadMoreContainerBase.this.onReachBottom();
                }
            }

            public void onScroll(AbsListView view, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
                if (null != LoadMoreContainerBase.this.mOnScrollListener) {
                    LoadMoreContainerBase.this.mOnScrollListener.onScroll(view, firstVisibleItem, visibleItemCount, totalItemCount);
                }
                this.mIsEnd = firstVisibleItem + visibleItemCount >= totalItemCount - 1;
            }
        });
    }

    private void performLoadMore() {
        if (this.mIsLoading || !this.mHasMore) {
            return;
        }
        this.mIsLoading = true;
        if (this.mLoadMoreUIHandler != null && (!this.mListEmpty || this.mShowLoadingForFirstPage)) {
            this.mLoadMoreUIHandler.onLoading(this);
        }
        if (null != this.mLoadMoreHandler) {
            this.mLoadMoreHandler.onLoadMore(this);
        }
    }

    private void onReachBottom() {
        if (this.mAutoLoadMore) {
            this.performLoadMore();
        } else if (this.mHasMore) {
            this.mLoadMoreUIHandler.onWaitToLoadMore(this);
        }
    }

    @Override
    public void setShowLoadingForFirstPage(boolean showLoading) {
        this.mShowLoadingForFirstPage = showLoading;
    }

    @Override
    public void setAutoLoadMore(boolean autoLoadMore) {
        this.mAutoLoadMore = autoLoadMore;
    }

    @Override
    public void setOnScrollListener(AbsListView.OnScrollListener l) {
        this.mOnScrollListener = l;
    }

    @Override
    public void setLoadMoreView(View view) {
        if (this.mAbsListView == null) {
            this.mFooterView = view;
            return;
        }
        if (this.mFooterView != null && this.mFooterView != view) {
            this.removeFooterView(view);
        }
        this.mFooterView = view;
        this.mFooterView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                LoadMoreContainerBase.this.performLoadMore();
            }
        });
        this.addFooterView(view);
    }

    @Override
    public void setLoadMoreUIHandler(LoadMoreUIHandler handler) {
        this.mLoadMoreUIHandler = handler;
    }

    @Override
    public void setLoadMoreHandler(LoadMoreHandler handler) {
        this.mLoadMoreHandler = handler;
    }

    @Override
    public void loadMoreFinish(boolean emptyResult, boolean hasMore) {
        this.mListEmpty = emptyResult;
        this.mIsLoading = false;
        this.mHasMore = hasMore;
        if (this.mLoadMoreUIHandler != null) {
            this.mLoadMoreUIHandler.onLoadFinish(this, emptyResult, hasMore);
        }
    }

    protected abstract void addFooterView(View var1);

    protected abstract void removeFooterView(View var1);

    protected abstract AbsListView retrieveAbsListView();
}

