/*
 * Decompiled with CFR 0.152.
 */
package in.srain.cube.views.loadmore;

import android.content.Context;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import android.widget.TextView;
import in.srain.cube.R;
import in.srain.cube.views.loadmore.LoadMoreContainer;
import in.srain.cube.views.loadmore.LoadMoreUIHandler;

public class LoadMoreDefaultFooterView
extends RelativeLayout
implements LoadMoreUIHandler {
    private TextView mTextView;

    public LoadMoreDefaultFooterView(Context context) {
        this(context, null);
    }

    public LoadMoreDefaultFooterView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public LoadMoreDefaultFooterView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.setupViews();
    }

    private void setupViews() {
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.cube_views_load_more_default_footer, (ViewGroup)this);
        this.mTextView = (TextView)this.findViewById(R.id.cube_views_load_more_default_footer_text_view);
    }

    @Override
    public void onLoading(LoadMoreContainer container) {
        this.setVisibility(0);
        this.mTextView.setText(R.string.cube_views_load_more_loading);
    }

    @Override
    public void onLoadFinish(LoadMoreContainer container, boolean empty, boolean hasMore) {
        if (!hasMore) {
            this.setVisibility(0);
            if (empty) {
                this.mTextView.setText(R.string.cube_views_load_more_loaded_empty);
            } else {
                this.mTextView.setText(R.string.cube_views_load_more_loaded_no_more);
            }
        } else {
            this.setVisibility(4);
        }
    }

    @Override
    public void onWaitToLoadMore(LoadMoreContainer container) {
        this.setVisibility(0);
        this.mTextView.setText(R.string.cube_views_load_more_click_to_load_more);
    }
}

