/*
 * Decompiled with CFR 0.152.
 */
package in.srain.cube.views.mix;

import android.os.Handler;
import android.os.Looper;

public class AutoPlayer {
    private PlayDirection mDirection = PlayDirection.to_right;
    private PlayRecycleMode mPlayRecycleMode = PlayRecycleMode.repeat_from_start;
    private int mTimeInterval = 5000;
    private Playable mPlayable;
    private Runnable mTimerTask;
    private boolean mSkipNext = false;
    private int mTotal;
    private boolean mPlaying = false;
    private boolean mPaused = false;

    public AutoPlayer(Playable playable) {
        this.mPlayable = playable;
    }

    public void play() {
        this.play(0, PlayDirection.to_right);
    }

    public void skipNext() {
        this.mSkipNext = true;
    }

    public void play(int start, PlayDirection direction) {
        if (this.mPlaying) {
            return;
        }
        this.mTotal = this.mPlayable.getTotal();
        if (this.mTotal <= 1) {
            return;
        }
        this.mPlaying = true;
        this.playTo(start);
        final Handler handler = new Handler(Looper.myLooper());
        this.mTimerTask = new Runnable(){

            @Override
            public void run() {
                if (!AutoPlayer.this.mPaused) {
                    AutoPlayer.this.playNextFrame();
                }
                if (AutoPlayer.this.mPlaying) {
                    handler.postDelayed(AutoPlayer.this.mTimerTask, (long)AutoPlayer.this.mTimeInterval);
                }
            }
        };
        handler.postDelayed(this.mTimerTask, (long)this.mTimeInterval);
    }

    public void play(int start) {
        this.play(start, PlayDirection.to_right);
    }

    public void stop() {
        if (!this.mPlaying) {
            return;
        }
        this.mPlaying = false;
    }

    public AutoPlayer setTimeInterval(int timeInterval) {
        this.mTimeInterval = timeInterval;
        return this;
    }

    public AutoPlayer setPlayRecycleMode(PlayRecycleMode playRecycleMode) {
        this.mPlayRecycleMode = playRecycleMode;
        return this;
    }

    private void playNextFrame() {
        if (this.mSkipNext) {
            this.mSkipNext = false;
            return;
        }
        int current = this.mPlayable.getCurrent();
        if (this.mDirection == PlayDirection.to_right) {
            if (current == this.mTotal - 1) {
                if (this.mPlayRecycleMode == PlayRecycleMode.play_back) {
                    this.mDirection = PlayDirection.to_left;
                    this.playNextFrame();
                } else {
                    this.playTo(0);
                }
            } else {
                this.playNext();
            }
        } else if (current == 0) {
            if (this.mPlayRecycleMode == PlayRecycleMode.play_back) {
                this.mDirection = PlayDirection.to_right;
                this.playNextFrame();
            } else {
                this.playTo(this.mTotal - 1);
            }
        } else {
            this.playPrevious();
        }
    }

    public void pause() {
        this.mPaused = true;
    }

    public void resume() {
        this.mPaused = false;
    }

    private void playTo(int to) {
        this.mPlayable.playTo(to);
    }

    private void playNext() {
        this.mPlayable.playNext();
    }

    private void playPrevious() {
        this.mPlayable.playPrevious();
    }

    public static enum PlayRecycleMode {
        repeat_from_start,
        play_back;

    }

    public static enum PlayDirection {
        to_left,
        to_right;

    }

    public static interface Playable {
        public void playTo(int var1);

        public void playNext();

        public void playPrevious();

        public int getTotal();

        public int getCurrent();
    }
}

