/*
 * Decompiled with CFR 0.152.
 */
package in.srain.cube.views.ptr;

import in.srain.cube.views.ptr.PtrFrameLayout;
import in.srain.cube.views.ptr.PtrUIHandler;
import in.srain.cube.views.ptr.indicator.PtrIndicator;

class PtrUIHandlerHolder
implements PtrUIHandler {
    private PtrUIHandler mHandler;
    private PtrUIHandlerHolder mNext;

    private boolean contains(PtrUIHandler handler) {
        return this.mHandler != null && this.mHandler == handler;
    }

    private PtrUIHandlerHolder() {
    }

    public boolean hasHandler() {
        return this.mHandler != null;
    }

    private PtrUIHandler getHandler() {
        return this.mHandler;
    }

    public static void addHandler(PtrUIHandlerHolder head, PtrUIHandler handler) {
        if (null == handler) {
            return;
        }
        if (head == null) {
            return;
        }
        if (null == head.mHandler) {
            head.mHandler = handler;
            return;
        }
        PtrUIHandlerHolder current = head;
        while (true) {
            if (current.contains(handler)) {
                return;
            }
            if (current.mNext == null) break;
            current = current.mNext;
        }
        PtrUIHandlerHolder newHolder = new PtrUIHandlerHolder();
        newHolder.mHandler = handler;
        current.mNext = newHolder;
    }

    public static PtrUIHandlerHolder create() {
        return new PtrUIHandlerHolder();
    }

    public static PtrUIHandlerHolder removeHandler(PtrUIHandlerHolder head, PtrUIHandler handler) {
        if (head == null || handler == null || null == head.mHandler) {
            return head;
        }
        PtrUIHandlerHolder current = head;
        PtrUIHandlerHolder pre = null;
        do {
            if (current.contains(handler)) {
                if (pre == null) {
                    head = current.mNext;
                    current.mNext = null;
                    current = head;
                    continue;
                }
                pre.mNext = current.mNext;
                current.mNext = null;
                current = pre.mNext;
                continue;
            }
            pre = current;
            current = current.mNext;
        } while (current != null);
        if (head == null) {
            head = new PtrUIHandlerHolder();
        }
        return head;
    }

    @Override
    public void onUIReset(PtrFrameLayout frame) {
        PtrUIHandlerHolder current = this;
        do {
            PtrUIHandler handler;
            if (null == (handler = current.getHandler())) continue;
            handler.onUIReset(frame);
        } while ((current = current.mNext) != null);
    }

    @Override
    public void onUIRefreshPrepare(PtrFrameLayout frame) {
        if (!this.hasHandler()) {
            return;
        }
        PtrUIHandlerHolder current = this;
        do {
            PtrUIHandler handler;
            if (null == (handler = current.getHandler())) continue;
            handler.onUIRefreshPrepare(frame);
        } while ((current = current.mNext) != null);
    }

    @Override
    public void onUIRefreshBegin(PtrFrameLayout frame) {
        PtrUIHandlerHolder current = this;
        do {
            PtrUIHandler handler;
            if (null == (handler = current.getHandler())) continue;
            handler.onUIRefreshBegin(frame);
        } while ((current = current.mNext) != null);
    }

    @Override
    public void onUIRefreshComplete(PtrFrameLayout frame) {
        PtrUIHandlerHolder current = this;
        do {
            PtrUIHandler handler;
            if (null == (handler = current.getHandler())) continue;
            handler.onUIRefreshComplete(frame);
        } while ((current = current.mNext) != null);
    }

    @Override
    public void onUIPositionChange(PtrFrameLayout frame, boolean isUnderTouch, byte status, PtrIndicator ptrIndicator) {
        PtrUIHandlerHolder current = this;
        do {
            PtrUIHandler handler;
            if (null == (handler = current.getHandler())) continue;
            handler.onUIPositionChange(frame, isUnderTouch, status, ptrIndicator);
        } while ((current = current.mNext) != null);
    }
}

