/*
 * Decompiled with CFR 0.152.
 */
package in.srain.cube.views.ptr.header;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import android.view.animation.Animation;
import android.view.animation.Transformation;
import in.srain.cube.views.ptr.PtrFrameLayout;
import in.srain.cube.views.ptr.PtrUIHandler;
import in.srain.cube.views.ptr.PtrUIHandlerHook;
import in.srain.cube.views.ptr.header.MaterialProgressDrawable;
import in.srain.cube.views.ptr.indicator.PtrIndicator;

public class MaterialHeader
extends View
implements PtrUIHandler {
    private MaterialProgressDrawable mDrawable;
    private float mScale = 1.0f;
    private PtrFrameLayout mPtrFrameLayout;
    private Animation mScaleAnimation = new Animation(){

        public void applyTransformation(float interpolatedTime, Transformation t) {
            MaterialHeader.this.mScale = 1.0f - interpolatedTime;
            MaterialHeader.this.mDrawable.setAlpha((int)(255.0f * MaterialHeader.this.mScale));
            MaterialHeader.this.invalidate();
        }
    };

    public MaterialHeader(Context context) {
        super(context);
        this.initView();
    }

    public MaterialHeader(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.initView();
    }

    public MaterialHeader(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.initView();
    }

    public void setPtrFrameLayout(PtrFrameLayout layout2) {
        final PtrUIHandlerHook mPtrUIHandlerHook = new PtrUIHandlerHook(){

            @Override
            public void run() {
                MaterialHeader.this.startAnimation(MaterialHeader.this.mScaleAnimation);
            }
        };
        this.mScaleAnimation.setDuration(200L);
        this.mScaleAnimation.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                mPtrUIHandlerHook.resume();
            }

            public void onAnimationRepeat(Animation animation) {
            }
        });
        this.mPtrFrameLayout = layout2;
        this.mPtrFrameLayout.setRefreshCompleteHook(mPtrUIHandlerHook);
    }

    private void initView() {
        this.mDrawable = new MaterialProgressDrawable(this.getContext(), this);
        this.mDrawable.setBackgroundColor(-1);
        this.mDrawable.setCallback((Drawable.Callback)this);
    }

    public void invalidateDrawable(Drawable dr) {
        if (dr == this.mDrawable) {
            this.invalidate();
        } else {
            super.invalidateDrawable(dr);
        }
    }

    public void setColorSchemeColors(int[] colors) {
        this.mDrawable.setColorSchemeColors(colors);
        this.invalidate();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int height = this.mDrawable.getIntrinsicHeight() + this.getPaddingTop() + this.getPaddingBottom();
        heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000);
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        int size = this.mDrawable.getIntrinsicHeight();
        this.mDrawable.setBounds(0, 0, size, size);
    }

    protected void onDraw(Canvas canvas) {
        int saveCount = canvas.save();
        Rect rect = this.mDrawable.getBounds();
        int l = this.getPaddingLeft() + (this.getMeasuredWidth() - this.mDrawable.getIntrinsicWidth()) / 2;
        canvas.translate((float)l, (float)this.getPaddingTop());
        canvas.scale(this.mScale, this.mScale, rect.exactCenterX(), rect.exactCenterY());
        this.mDrawable.draw(canvas);
        canvas.restoreToCount(saveCount);
    }

    @Override
    public void onUIReset(PtrFrameLayout frame) {
        this.mScale = 1.0f;
        this.mDrawable.stop();
    }

    @Override
    public void onUIRefreshPrepare(PtrFrameLayout frame) {
    }

    @Override
    public void onUIRefreshBegin(PtrFrameLayout frame) {
        this.mDrawable.setAlpha(255);
        this.mDrawable.start();
    }

    @Override
    public void onUIRefreshComplete(PtrFrameLayout frame) {
        this.mDrawable.stop();
    }

    @Override
    public void onUIPositionChange(PtrFrameLayout frame, boolean isUnderTouch, byte status, PtrIndicator ptrIndicator) {
        float percent = Math.min(1.0f, ptrIndicator.getCurrentPercent());
        if (status == 2) {
            this.mDrawable.setAlpha((int)(255.0f * percent));
            this.mDrawable.showArrow(true);
            float strokeStart = percent * 0.8f;
            this.mDrawable.setStartEndTrim(0.0f, Math.min(0.8f, strokeStart));
            this.mDrawable.setArrowScale(Math.min(1.0f, percent));
            float rotation = (-0.25f + 0.4f * percent + percent * 2.0f) * 0.5f;
            this.mDrawable.setProgressRotation(rotation);
            this.invalidate();
        }
    }
}

