/*
 * Decompiled with CFR 0.152.
 */
package in.virit.mopo;

import com.microsoft.playwright.Locator;
import com.microsoft.playwright.Page;

public class GridPw {
    private final Locator root;

    public GridPw(Locator gridLocator) {
        this.root = gridLocator;
    }

    public GridPw(Page page) {
        this(page.locator("vaadin-grid"));
    }

    public int getRenderedRowCount() {
        Integer evaluate = (Integer)this.root.elementHandle().evaluate("e => e._getRenderedRows().length");
        return evaluate;
    }

    public int getFirstVisibleRowIndex() {
        return (Integer)this.root.elementHandle().evaluate("e => e._firstVisibleIndex");
    }

    public void scrollToIndex(int index) {
        this.root.elementHandle().evaluate("e => e.scrollToIndex(" + index + ")");
        int value = (Integer)this.root.evaluate("g => {\n    return new Promise((resolve, reject) => {\n        var x = 0;\n        const isDoneLoading = () => {\n            return !g.$connector.hasRootRequestQueue()\n        };\n\n        const isVaadinConnectionActive = () => {\n            if (window.Vaadin && window.Vaadin.Flow && window.Vaadin.Flow.clients) {\n              var clients = window.Vaadin.Flow.clients;\n              for (var client in clients) {\n                if (clients[client].isActive()) {\n                  return false;\n                }\n              }\n              return true;\n            } else if (window.Vaadin && window.Vaadin.Flow && window.Vaadin.Flow.devServerIsNotLoaded) {\n              return false;\n            } else {\n              return true;\n            }\n        };\n\n        if (isDoneLoading() && !isVaadinConnectionActive()) {\n            resolve(x);\n            return;\n        }\n\n        var intervalID = window.setInterval(function () {\n            if (isDoneLoading() && !isVaadinConnectionActive()) {\n                window.clearInterval(intervalID);\n                resolve(x+1);\n            } else {\n               if (++x === 10) {\n                   window.clearInterval(intervalID);\n                   resolve(-1);\n               }\n           }\n        }, 100);\n    });\n}");
    }

    public void selectRow(int rowIndex) {
        String script = "grid => {\n    var firstRowIndex = %s;\n    var lastRowIndex = firstRowIndex;\n    var rowsInDom = grid._getRenderedRows();\n    var rows = Array.from(rowsInDom).filter((row) => { return row.index >= firstRowIndex && row.index <= lastRowIndex;});\n    var row = rows[0];\n    grid.activeItem = row._item;\n}\n".formatted(rowIndex);
        this.root.elementHandle().evaluate(script);
    }

    public RowPw getRow(int rowIndex) {
        if (!this.isRowInView(rowIndex)) {
            this.scrollToIndex(rowIndex);
        }
        return new RowPw(rowIndex);
    }

    public boolean isRowInView(int rowIndex) {
        return this.getFirstVisibleRowIndex() <= rowIndex && rowIndex <= this.getLastVisibleRowIndex();
    }

    public int getLastVisibleRowIndex() {
        return (Integer)this.root.elementHandle().evaluate("e => e._lastVisibleIndex");
    }

    public class RowPw {
        private final int rowIndex;

        private RowPw(int rowIndex) {
            this.rowIndex = rowIndex;
        }

        public Locator getCell(int cellIndex) {
            int indexInVirtualTable = (Integer)GridPw.this.root.evaluate("g => g._getRenderedRows().indexOf(g._getRenderedRows().filter(r => r.index == %s)[0]);".formatted(this.rowIndex));
            String name = GridPw.this.root.locator("#items tr:nth-child(%s) td:nth-child(%s) slot".formatted(++indexInVirtualTable, cellIndex + 1)).getAttribute("name");
            return GridPw.this.root.locator("vaadin-grid-cell-content[slot='%s']".formatted(name));
        }

        public Locator getCell(String headerText) {
            String slot = GridPw.this.root.locator("vaadin-grid-cell-content").filter(new Locator.FilterOptions().setHasText(headerText)).getAttribute("slot");
            String substring = slot.substring(slot.lastIndexOf("-") + 1);
            int cellIndex = Integer.parseInt(substring);
            return this.getCell(cellIndex);
        }

        public void select() {
            GridPw.this.selectRow(this.rowIndex);
        }
    }
}

