/*
 * Decompiled with CFR 0.152.
 */
package in.virit.mopo;

import com.microsoft.playwright.Browser;
import com.microsoft.playwright.ElementHandle;
import com.microsoft.playwright.Locator;
import com.microsoft.playwright.Page;
import com.microsoft.playwright.TimeoutError;
import com.microsoft.playwright.assertions.PlaywrightAssertions;
import java.util.ArrayList;
import java.util.List;

public class Mopo {
    private final Page page;

    public Mopo(Page page) {
        this.page = page;
    }

    public static void waitForConnectionToSettle(Page page) {
        int minWait = 500;
        Mopo.waitForConnectionToSettle(page, minWait);
    }

    public static void waitForConnectionToSettle(Page page, int minWait) {
        long start = System.currentTimeMillis();
        page.waitForTimeout((double)minWait);
        PlaywrightAssertions.assertThat((Locator)page.locator("vaadin-connection-indicator[loading]")).hasCount(0);
    }

    public static void assertNoJsErrors(Page page) {
        try {
            PlaywrightAssertions.assertThat((Locator)page.locator("vaadin-dev-tools")).isVisible();
            Mopo.waitForConnectionToSettle(page);
            ElementHandle elementHandle = page.waitForSelector("vaadin-dev-tools>div.error", new Page.WaitForSelectorOptions().setTimeout(100.0));
            if (elementHandle != null) {
                String msg = page.locator("vaadin-dev-tools div.message.error").last().textContent();
                throw new AssertionError((Object)("JS error in dev console: " + msg));
            }
        }
        catch (TimeoutError e) {
            return;
        }
    }

    public void waitForConnectionToSettle() {
        Mopo.waitForConnectionToSettle(this.page);
    }

    public void assertNoJsErrors() {
        Mopo.assertNoJsErrors(this.page);
    }

    public List<String> getViewsReportedByDevMode(Browser browser, String rootUrl) {
        ArrayList<String> urls = new ArrayList<String>();
        Page page1 = browser.newPage();
        page1.navigate(rootUrl);
        page1.waitForSelector("#outlet a");
        List anchors = page1.locator("#outlet a").elementHandles();
        for (ElementHandle anchor : anchors) {
            String href = anchor.getAttribute("href");
            if (href == null) continue;
            urls.add(href);
        }
        page1.close();
        return urls;
    }

    public void driveIn(String selector, Runnable taskToRun) {
        this.driveIn(this.page.locator(selector), taskToRun);
    }

    public void driveIn(Locator locator, Runnable taskToRun) {
        PlaywrightAssertions.assertThat((Locator)locator).isVisible();
        taskToRun.run();
        PlaywrightAssertions.assertThat((Locator)locator).not().isVisible();
    }

    public void click(Locator locator) {
        locator.click();
        this.waitForConnectionToSettle();
    }

    public void click(String selector) {
        this.page.locator(selector).click();
        this.waitForConnectionToSettle();
    }
}

