/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.firitin.appframework;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.html.ListItem;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.router.PageTitle;
import com.vaadin.flow.router.RouterLink;
import org.apache.commons.lang3.StringUtils;
import org.vaadin.firitin.appframework.MenuItem;

public class NavigationItem
extends ListItem {
    private final Class<? extends Component> navigationTarget;
    private final String text;

    public NavigationItem(Class<? extends Component> navigationTarget) {
        super(new Component[]{new RouterLink("", navigationTarget)});
        this.text = NavigationItem.getMenuTextFromClass(navigationTarget);
        RouterLink rl = (RouterLink)this.getChildren().findFirst().get();
        rl.addClassNames(new String[]{"flex", "mx-s", "p-s", "relative", "text-secondary"});
        MenuItem me = navigationTarget.getAnnotation(MenuItem.class);
        if (me != null) {
            rl.add(new Component[]{new Icon(me.icon())});
        }
        Span text = new Span(this.text);
        text.addClassNames(new String[]{"font-medium", "text-s"});
        rl.add(new Component[]{text});
        this.navigationTarget = navigationTarget;
    }

    public static String getMenuTextFromClass(Class<? extends Component> navigationTarget) {
        String text;
        MenuItem me = navigationTarget.getAnnotation(MenuItem.class);
        if (me != null && !me.title().isEmpty()) {
            text = me.title();
        } else {
            PageTitle title = navigationTarget.getAnnotation(PageTitle.class);
            if (title == null) {
                String simpleName = navigationTarget.getSimpleName();
                if (simpleName.endsWith("View")) {
                    simpleName = simpleName.substring(0, simpleName.length() - 4);
                }
                text = StringUtils.join((Object[])StringUtils.splitByCharacterTypeCamelCase((String)simpleName), (char)' ');
            } else {
                text = title.value();
            }
        }
        return text;
    }

    public String getText() {
        return this.text;
    }

    public Class<? extends Component> getNavigationTarget() {
        return this.navigationTarget;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        String color = enabled ? "" : "gray";
        this.getStyle().set("color", color);
    }
}

