/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.firitin.fields;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.checkbox.Checkbox;
import com.vaadin.flow.component.datetimepicker.DateTimePicker;
import com.vaadin.flow.component.html.Span;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.component.select.Select;
import com.vaadin.flow.component.textfield.IntegerField;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.vaadin.firitin.components.button.VButton;
import org.vaadin.firitin.components.datetimepicker.VDateTimePicker;
import org.vaadin.firitin.components.orderedlayout.VHorizontalLayout;
import org.vaadin.firitin.components.orderedlayout.VVerticalLayout;

public class MultiDateTimeField
extends Composite<VerticalLayout>
implements HasValue<HasValue.ValueChangeEvent<List<LocalDateTime>>, List<LocalDateTime>>,
HasSize {
    private List<LocalDateTime> value;
    DateTimePicker next = new VDateTimePicker();
    Button addEntry = new Button((Component)VaadinIcon.PLUS.create());
    Checkbox repeat = new Checkbox("Repeat");
    Select<RepeatMode> repeatMode = new Select();
    IntegerField repeatTimes = new IntegerField();
    Span repeatTimesText = new Span("times");
    VerticalLayout existingValues = (VerticalLayout)((VVerticalLayout)new VVerticalLayout().withMargin(false)).withPadding(false).withSpacing(false);

    public MultiDateTimeField() {
        this.value = new ArrayList<LocalDateTime>();
        this.next.setWidth("260px");
        this.next.setLabel("Add new date (+)");
        this.addEntry.getElement().setAttribute("title", "Click to add new date(s) to selection");
        VHorizontalLayout newRowForm = new VHorizontalLayout(new Component[]{this.next, this.repeat, this.repeatTimes, this.repeatTimesText, this.repeatMode, this.addEntry}).withDefaultVerticalComponentAlignment(FlexComponent.Alignment.BASELINE);
        ((VerticalLayout)this.getContent()).setPadding(false);
        ((VerticalLayout)this.getContent()).add(new Component[]{this.existingValues, newRowForm});
        this.next.setValue(LocalDateTime.now().withMinute(0).withNano(0));
        this.repeatMode.setItems((Object[])RepeatMode.values());
        this.repeatMode.setValue((Object)RepeatMode.weekly);
        this.repeatTimes.setMin(1);
        this.repeatTimes.setMax(52);
        this.repeatTimes.setValue((Number)1);
        this.repeat.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> Stream.of(this.repeatTimes, this.repeatTimesText, this.repeatMode).forEach(c -> c.setVisible(((Boolean)this.repeat.getValue()).booleanValue())));
        this.repeat.setValue((Object)true);
        this.repeat.setValue((Object)false);
        this.addEntry.addClickListener((ComponentEventListener & Serializable)e -> {
            LocalDateTime newValue = (LocalDateTime)this.next.getValue();
            this.value.add(newValue);
            this.addRow(newValue);
            if (((Boolean)this.repeat.getValue()).booleanValue()) {
                for (int i = 0; i < (Integer)this.repeatTimes.getValue(); ++i) {
                    newValue = newValue.plusDays(this.repeatMode.getValue() == RepeatMode.daily ? 1L : 7L);
                    this.value.add(newValue);
                    this.addRow(newValue);
                }
                this.next.setValue(newValue);
            }
            this.fireValueChange();
        });
    }

    private void addRow(LocalDateTime newValue) {
        VHorizontalLayout row = new VHorizontalLayout();
        VDateTimePicker dateTimePicker = new VDateTimePicker(newValue, (HasValue.ValueChangeListener<AbstractField.ComponentValueChangeEvent<DateTimePicker, LocalDateTime>>)(HasValue.ValueChangeListener & Serializable)event -> {
            LocalDateTime oldValue = (LocalDateTime)event.getOldValue();
            this.value.set(this.value.indexOf(oldValue), (LocalDateTime)event.getValue());
            this.fireValueChange();
        });
        dateTimePicker.setWidth("260px");
        VButton deleteButton = new VButton((Component)VaadinIcon.TRASH.create(), (ComponentEventListener<ClickEvent<Button>>)(ComponentEventListener & Serializable)e -> {
            this.value.remove(dateTimePicker.getValue());
            this.existingValues.remove(new Component[]{row});
            this.fireValueChange();
        });
        row.add(new Component[]{dateTimePicker, deleteButton});
        this.existingValues.add(new Component[]{row});
    }

    private void fireValueChange() {
        this.fireEvent((ComponentEvent)new AbstractField.ComponentValueChangeEvent((Component)this, (HasValue)this, null, true));
    }

    public void setValue(List<LocalDateTime> value) {
        this.value = value;
        this.existingValues.removeAll();
        value.forEach(this::addRow);
    }

    public List<LocalDateTime> getValue() {
        return this.value;
    }

    public Registration addValueChangeListener(HasValue.ValueChangeListener<? super HasValue.ValueChangeEvent<List<LocalDateTime>>> listener) {
        ComponentEventListener & Serializable componentListener = (ComponentEventListener & Serializable)event -> {
            AbstractField.ComponentValueChangeEvent valueChangeEvent = (AbstractField.ComponentValueChangeEvent)event;
            listener.valueChanged((HasValue.ValueChangeEvent)valueChangeEvent);
        };
        return this.addListener(AbstractField.ComponentValueChangeEvent.class, componentListener);
    }

    public void setReadOnly(boolean readOnly) {
        ((VerticalLayout)this.getContent()).setEnabled(false);
    }

    public boolean isReadOnly() {
        return ((VerticalLayout)this.getContent()).isEnabled();
    }

    public void setRequiredIndicatorVisible(boolean requiredIndicatorVisible) {
    }

    public boolean isRequiredIndicatorVisible() {
        return false;
    }

    private static enum RepeatMode {
        daily,
        weekly;

    }
}

