/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.firitin.util;

import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.page.Page;
import com.vaadin.flow.function.SerializableConsumer;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Objects;

public class BrowserCookie {
    public static void setCookie(String key, String value) {
        BrowserCookie.setCookie(key, value, "/");
    }

    public static void setCookie(String key, String value, LocalDateTime expirationTime) {
        String expires = BrowserCookie.toCookieGMTDate(expirationTime);
        BrowserCookie.getPage().executeJavaScript(String.format("document.cookie = \"%s=%s; expires=%s\";", key, value, expires), new Serializable[0]);
    }

    private static Page getPage() {
        return BrowserCookie.getUI().getPage();
    }

    private static UI getUI() {
        UI current = UI.getCurrent();
        Objects.requireNonNull(current, "UI.getCurrent() shouldn't return null when executing this method!");
        return current;
    }

    private static String toCookieGMTDate(LocalDateTime expirationTime) {
        ZonedDateTime zdt = ZonedDateTime.of(expirationTime, ZoneOffset.UTC);
        String expires = zdt.format(DateTimeFormatter.RFC_1123_DATE_TIME);
        return expires;
    }

    public static void setCookie(String key, String value, String path, LocalDateTime expirationTime) {
        String expires = BrowserCookie.toCookieGMTDate(expirationTime);
        BrowserCookie.getPage().executeJavaScript(String.format("document.cookie = \"%s=%s; path=%s\"; Expires=%s\";", key, value, path, expires), new Serializable[0]);
    }

    public static void setCookie(String key, String value, String path) {
        BrowserCookie.getPage().executeJavaScript(String.format("document.cookie = \"%s=%s; path=%s\";", key, value, path), new Serializable[0]);
    }

    public static void detectCookieValue(String key, Callback callback) {
        UI.getCurrent().getElement().executeJs("var keyEq = \"" + key + "=\";var ca = document.cookie.split(\";\");\nfor (var i = 0; i < ca.length; i++) {\n  let c = ca[i];\n  while (c.charAt(0) == \" \") c = c.substring(1, c.length);\n  if (c.indexOf(keyEq) == 0) {\n    return c.substring(keyEq.length, c.length);\n  }\n}return \"\";", new Serializable[0]).then(String.class, (SerializableConsumer & Serializable)cookieValue -> callback.onValueDetected((String)cookieValue));
    }

    public static <E extends HasValue.ValueChangeEvent<V>, V> void bindValueToCookie(HasValue<E, V> field, String name, Callback cb) {
        if (Objects.isNull(name) || name.isEmpty()) {
            throw new IllegalArgumentException("Name must not be null or empty");
        }
        if (Objects.isNull(field)) {
            throw new IllegalArgumentException("Field must not be null");
        }
        BrowserCookie.detectCookieValue(name, v -> {
            if (v != null) {
                cb.onValueDetected(v);
            }
        });
        field.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> BrowserCookie.setCookie(name, event.getValue().toString(), LocalDateTime.now().plusMonths(1L)));
    }

    public static void bindValueToCookie(HasValue<? extends HasValue.ValueChangeEvent<String>, String> field, String name) {
        if (Objects.isNull(name) || name.isEmpty()) {
            throw new IllegalArgumentException("Name must not be null or empty");
        }
        if (Objects.isNull(field)) {
            throw new IllegalArgumentException("Field must not be null");
        }
        BrowserCookie.detectCookieValue(name, v -> {
            if (v != null) {
                field.setValue((Object)v);
            }
        });
        field.addValueChangeListener((HasValue.ValueChangeListener & Serializable)event -> BrowserCookie.setCookie(name, (String)event.getValue(), LocalDateTime.now().plusMonths(1L)));
    }

    public static interface Callback {
        public void onValueDetected(String var1);
    }
}

