/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.firitin.appframework;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.applayout.AppLayout;
import com.vaadin.flow.component.applayout.DrawerToggle;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.dependency.CssImport;
import com.vaadin.flow.component.dependency.NpmPackage;
import com.vaadin.flow.component.html.Footer;
import com.vaadin.flow.component.html.H1;
import com.vaadin.flow.component.html.H2;
import com.vaadin.flow.component.html.Header;
import com.vaadin.flow.component.html.Nav;
import com.vaadin.flow.component.html.Section;
import com.vaadin.flow.component.html.UnorderedList;
import com.vaadin.flow.router.RouteConfiguration;
import com.vaadin.flow.router.RoutesChangedListener;
import com.vaadin.flow.server.Command;
import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.WeakHashMap;
import org.vaadin.firitin.appframework.MenuItem;
import org.vaadin.firitin.appframework.NavigationItem;

@CssImport.Container(value={@CssImport(value="./org/vaadin/firitin/layouts/appframework.css"), @CssImport(value="lumo-css-framework/all-classes.css")})
@NpmPackage(value="lumo-css-framework", version="3.0.11")
public abstract class MainLayout
extends AppLayout {
    private UnorderedList menu;
    private H1 viewTitle;
    private List<NavigationItem> navigationItems = new ArrayList<NavigationItem>();
    private Stack<Component> viewStack = new Stack();
    private Map<Component, String> explicitViewTitles = new WeakHashMap<Component, String>();

    public MainLayout() {
        this.getElement().getClassList().add((Object)"v-applayout");
    }

    protected void onAttach(AttachEvent attachEvent) {
        this.init();
        super.onAttach(attachEvent);
    }

    protected void init() {
        if (this.viewTitle != null) {
            return;
        }
        this.setPrimarySection(AppLayout.Section.DRAWER);
        this.addToNavbar(true, new Component[]{this.createHeaderContent()});
        this.addToDrawer(new Component[]{this.createDrawerContent()});
        RouteConfiguration.forSessionScope().getAvailableRoutes().stream().filter(routeData -> {
            Class parentLayout = routeData.getParentLayout();
            if (parentLayout != null) {
                boolean assignableFrom = MainLayout.class.isAssignableFrom(parentLayout);
                return assignableFrom;
            }
            return false;
        }).forEach(rd -> {
            Class routeClass = rd.getNavigationTarget();
            if (!Modifier.isAbstract(routeClass.getModifiers())) {
                this.navigationItems.add(new NavigationItem(routeClass));
            }
        });
        RouteConfiguration.forApplicationScope().addRoutesChangeListener((RoutesChangedListener & Serializable)event -> {
            event.getRemovedRoutes().forEach(route -> {
                Iterator<NavigationItem> iterator = this.navigationItems.iterator();
                while (iterator.hasNext()) {
                    NavigationItem item = iterator.next();
                    if (item.getNavigationTarget() != route.getNavigationTarget()) continue;
                    iterator.remove();
                }
            });
            this.getUI().ifPresent(ui -> ui.access((Command & Serializable)() -> {
                List addedRoutes = event.getAddedRoutes();
                addedRoutes.stream().filter(routeData -> {
                    Class parentLayout = routeData.getParentLayout();
                    if (parentLayout != null) {
                        boolean assignableFrom = MainLayout.class.isAssignableFrom(parentLayout);
                        return assignableFrom;
                    }
                    return false;
                }).forEach(rd -> {
                    Class routeClass = rd.getNavigationTarget();
                    if (!Modifier.isAbstract(routeClass.getModifiers()) && routeClass != null) {
                        this.navigationItems.add(new NavigationItem(routeClass));
                    }
                });
                this.sortMenuItems();
                this.buildMenu();
            }));
        });
        this.sortMenuItems();
        this.buildMenu();
    }

    protected void sortMenuItems() {
        Collections.sort(this.navigationItems, new Comparator<NavigationItem>(){

            @Override
            public int compare(NavigationItem o1, NavigationItem o2) {
                int order2;
                MenuItem a1 = o1.getNavigationTarget().getAnnotation(MenuItem.class);
                MenuItem a2 = o2.getNavigationTarget().getAnnotation(MenuItem.class);
                if (a1 == null && a2 == null) {
                    return o1.getText().compareTo(o2.getText());
                }
                int order1 = a1 == null ? 1000 : a1.order();
                int n = order2 = a2 == null ? 1000 : a2.order();
                if (order1 == order2) {
                    return o1.getText().compareTo(o2.getText());
                }
                return order1 - order2;
            }
        });
    }

    public List<NavigationItem> getNavigationItems() {
        return this.navigationItems;
    }

    public void buildMenu() {
        this.menu.removeAll();
        this.navigationItems.stream().filter(this::checkAccess).forEach(xva$0 -> this.menu.add(new Component[]{xva$0}));
    }

    protected boolean checkAccess(NavigationItem navigationItem) {
        return true;
    }

    protected Component createHeaderContent() {
        DrawerToggle toggle = new DrawerToggle();
        toggle.addClassName("text-secondary");
        toggle.addThemeVariants(new ButtonVariant[]{ButtonVariant.LUMO_CONTRAST});
        toggle.getElement().setAttribute("aria-label", "Menu toggle");
        this.viewTitle = new H1();
        this.viewTitle.addClassNames(new String[]{"m-0", "text-l"});
        Header header = new Header(new Component[]{toggle, this.viewTitle});
        header.addClassNames(new String[]{"bg-base", "border-b", "border-contrast-10", "box-border", "flex", "h-xl", "items-center", "w-full"});
        return header;
    }

    protected Component createDrawerContent() {
        H2 appName = new H2(this.getDrawerHeader());
        appName.addClassNames(new String[]{"flex", "items-center", "h-xl", "m-0", "px-m", "text-m"});
        Section section = new Section(new Component[]{appName, this.createNavigation(), this.createFooter()});
        section.addClassNames(new String[]{"flex", "flex-col", "items-stretch", "max-h-full", "min-h-full"});
        return section;
    }

    private Nav createNavigation() {
        Nav nav = new Nav();
        nav.addClassNames(new String[]{"border-b", "border-contrast-10", "flex-grow", "overflow-auto"});
        nav.getElement().setAttribute("aria-labelledby", "views");
        this.menu = new UnorderedList();
        this.menu.addClassNames(new String[]{"list-none", "m-0", "p-0"});
        nav.add(new Component[]{this.menu});
        return nav;
    }

    protected abstract String getDrawerHeader();

    protected void afterNavigation() {
        this.init();
        super.afterNavigation();
        this.updateViewTitle();
    }

    private void updateViewTitle() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.viewStack.size(); ++i) {
            Component component;
            if (i > 0) {
                sb.append(" / ");
            }
            if (this.explicitViewTitles.containsKey(component = (Component)this.viewStack.get(i))) {
                sb.append(this.explicitViewTitles.get(component));
                continue;
            }
            sb.append(NavigationItem.getMenuTextFromClass(component.getClass()));
        }
        this.viewTitle.setText(sb.toString());
    }

    public void setContent(Component content) {
        while (this.viewStack.size() > 1) {
            this.closeSubView();
        }
        super.setContent(content);
        this.viewStack.clear();
        this.viewStack.push(content);
    }

    public void openSubView(Component component, String viewTitle) {
        this.viewStack.push(component);
        if (viewTitle != null) {
            this.explicitViewTitles.put(component, viewTitle);
        }
        super.setContent(component);
        this.updateViewTitle();
    }

    public void openSubView(Component component) {
        this.openSubView(component, null);
    }

    public void closeSubView(Component component) {
        Component pop = this.viewStack.pop();
        if (pop != component) {
            throw new IllegalStateException();
        }
        if (pop == null) {
            throw new IllegalStateException();
        }
        this.explicitViewTitles.remove(pop);
        super.setContent(this.viewStack.peek());
        this.updateViewTitle();
    }

    public void closeSubView() {
        Component pop = this.viewStack.pop();
        if (pop == null) {
            throw new IllegalStateException();
        }
        this.explicitViewTitles.remove(pop);
        super.setContent(this.viewStack.peek());
        this.updateViewTitle();
    }

    protected Footer createFooter() {
        Footer layout = new Footer();
        layout.addClassNames(new String[]{"flex", "items-center", "my-s", "px-m", "py-xs"});
        return layout;
    }
}

