/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.firitin.fields;

import com.vaadin.flow.component.AbstractField;
import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.Composite;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.orderedlayout.VerticalLayout;
import com.vaadin.flow.data.binder.BeanValidationBinder;
import com.vaadin.flow.data.binder.Binder;
import com.vaadin.flow.function.SerializableSupplier;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.vaadin.firitin.components.button.VButton;
import org.vaadin.firitin.fields.internalhtmltable.Table;
import org.vaadin.firitin.fields.internalhtmltable.TableCell;
import org.vaadin.firitin.fields.internalhtmltable.TableDataCell;
import org.vaadin.firitin.fields.internalhtmltable.TableRow;
import org.vaadin.firitin.form.AbstractForm;

public class ElementCollectionField<T>
extends Composite<VerticalLayout>
implements HasValue<HasValue.ValueChangeEvent<List<T>>, List<T>>,
HasSize {
    private final Class<T> clazz;
    private final Class<?> editorClass;
    private List<T> value;
    protected Table table;
    private T newItem;
    private Binder newItemForm;
    private SerializableSupplier<Object> editorInstantiator;

    public ElementCollectionField(Class<T> clazz, Class<?> editorClass) {
        this.clazz = clazz;
        this.editorClass = editorClass;
        this.table = new Table();
        ((VerticalLayout)this.getContent()).setPadding(false);
        ((VerticalLayout)this.getContent()).add(new Component[]{this.table});
    }

    public ElementCollectionField<T> withEditorInstantiator(SerializableSupplier<Object> editorInstantiator) {
        this.editorInstantiator = editorInstantiator;
        return this;
    }

    protected void configureColumneHeaders() {
        Field[] declaredFields = this.editorClass != null ? this.editorClass.getDeclaredFields() : this.clazz.getDeclaredFields();
        TableRow tr = new TableRow();
        for (int i = 0; i < declaredFields.length; ++i) {
            String fieldName = declaredFields[i].getName();
            tr.addHeaderCells(this.getHeaderForField(fieldName));
        }
        this.table.addRows(tr);
    }

    protected String getHeaderForField(String fieldName) {
        return StringUtils.capitalize((String)StringUtils.join((Object[])StringUtils.splitByCharacterTypeCamelCase((String)fieldName), (String)" "));
    }

    protected void addDeleteButtonColumn(TableRow row, T item) {
        TableDataCell cell = row.addDataCell();
        cell.add(new Component[]{new VButton((Component)VaadinIcon.TRASH.create(), (ComponentEventListener<ClickEvent<Button>>)(ComponentEventListener & Serializable)event -> {
            this.value.remove(item);
            row.getParent().ifPresent(p -> ((Table)p).removeRows(row));
        })});
    }

    private void fireValueChange() {
        this.fireEvent((ComponentEvent)new AbstractField.ComponentValueChangeEvent((Component)this, (HasValue)this, null, true));
    }

    public void setValue(List<T> value) {
        this.value = value;
        this.table.removeAllRows();
        this.configureColumneHeaders();
        value.forEach(this::addNewRow);
        this.addRowForNewItem();
    }

    private void addRowForNewItem() {
        this.newItem = this.instantiateNewItem();
        this.newItemForm = this.addNewRow(this.newItem);
        this.getLastCell().setVisible(false);
    }

    private TableCell getLastCell() {
        TableRow lastRow = (TableRow)((Object)this.table.getRows().get(this.table.getRows().size() - 1));
        return lastRow.getCells().get(lastRow.getCells().size() - 1);
    }

    private BeanValidationBinder<T> addNewRow(T item) {
        TableRow tr;
        BeanValidationBinder binder = new BeanValidationBinder(this.clazz);
        Object row = this.instantiateRowObject();
        binder.bindInstanceFields(row);
        binder.setBean(item);
        if (row instanceof AbstractForm) {
            AbstractForm form = (AbstractForm)((Object)row);
            ((AbstractForm)((Object)row)).setEntity(item);
            tr = (TableRow)((Object)form.getContent().getChildren().findFirst().get());
        } else {
            Field[] fields = this.editorClass.getDeclaredFields();
            Component[] components = new Component[fields.length];
            for (int i = 0; i < fields.length; ++i) {
                Field field = fields[i];
                field.setAccessible(true);
                try {
                    components[i] = (Component)field.get(row);
                    continue;
                }
                catch (Exception e2) {
                    throw new RuntimeException(e2);
                }
            }
            tr = new TableRow(components);
        }
        binder.setBean(item);
        this.addDeleteButtonColumn(tr, item);
        binder.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
            if (binder == this.newItemForm) {
                if (e.isFromClient() && this.newItemForm.isValid()) {
                    this.value.add(this.newItem);
                    this.getLastCell().setVisible(true);
                    this.addRowForNewItem();
                    this.fireValueChange();
                }
            } else {
                this.fireValueChange();
            }
        });
        this.table.addRows(tr);
        return binder;
    }

    protected T instantiateNewItem() {
        try {
            return this.clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private Object instantiateRowObject() {
        try {
            if (this.editorInstantiator != null) {
                return this.editorInstantiator.get();
            }
            return this.editorClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public List<T> getValue() {
        return this.value;
    }

    public Registration addValueChangeListener(HasValue.ValueChangeListener<? super HasValue.ValueChangeEvent<List<T>>> listener) {
        ComponentEventListener & Serializable componentListener = (ComponentEventListener & Serializable)event -> {
            AbstractField.ComponentValueChangeEvent valueChangeEvent = (AbstractField.ComponentValueChangeEvent)event;
            listener.valueChanged((HasValue.ValueChangeEvent)valueChangeEvent);
        };
        return this.addListener(AbstractField.ComponentValueChangeEvent.class, componentListener);
    }

    public void setReadOnly(boolean readOnly) {
    }

    public boolean isReadOnly() {
        return false;
    }

    public void setRequiredIndicatorVisible(boolean requiredIndicatorVisible) {
    }

    public boolean isRequiredIndicatorVisible() {
        return false;
    }
}

