/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.firitin.fields;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.customfield.CustomField;
import com.vaadin.flow.component.datepicker.DatePicker;
import com.vaadin.flow.component.notification.Notification;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.textfield.TextField;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import org.vaadin.firitin.components.datepicker.VDatePicker;

public class LocalDateTimeField
extends CustomField<LocalDateTime> {
    private DatePicker datePicker = new VDatePicker();
    private TextField hour = new TextField();
    private TextField minute = new TextField();
    private LocalDateTime value;

    public LocalDateTimeField() {
        this.add(new Component[]{new HorizontalLayout(new Component[]{this.datePicker, this.hour, this.minute})});
        this.hour.setPattern("[0-2][0-9]");
        this.hour.setWidth("3em");
        this.hour.setAutoselect(true);
        this.minute.setPattern("[0-5][0-9]");
        this.minute.setWidth("3em");
        this.minute.setAutoselect(true);
        HasValue.ValueChangeListener & Serializable listener = (HasValue.ValueChangeListener & Serializable)e -> {
            if (e.isFromClient()) {
                this.updateFromFields();
            }
        };
        this.hour.addValueChangeListener((HasValue.ValueChangeListener)listener);
        this.minute.addValueChangeListener((HasValue.ValueChangeListener)listener);
        this.datePicker.addValueChangeListener((HasValue.ValueChangeListener)listener);
    }

    public LocalDateTimeField(String label) {
        this();
        this.setLabel(label);
    }

    protected LocalDateTime generateModelValue() {
        return this.value;
    }

    protected void setPresentationValue(LocalDateTime newValue) {
        this.datePicker.setValue((Object)newValue.toLocalDate());
        this.hour.setValue(String.format("%02d", newValue.getHour()));
        this.minute.setValue(String.format("%02d", newValue.getMinute()));
        this.value = newValue;
    }

    private void updateFromFields() {
        try {
            this.value = LocalDateTime.of((LocalDate)this.datePicker.getValue(), LocalTime.of(Integer.valueOf(this.hour.getValue()), Integer.valueOf(this.minute.getValue())));
        }
        catch (Exception e) {
            this.reportInvalidFormat(e);
        }
    }

    protected void reportInvalidFormat(Exception e) {
        Notification.show((String)"Please fill time in proper 24h format");
    }
}

