/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.firitin.util;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.function.SerializableConsumer;
import java.io.Serializable;

public class WebStorage {
    public static void setItem(String key, String value) {
        WebStorage.setItem(Storage.localStorage, key, value);
    }

    public static void setItem(Storage storage, String key, String value) {
        WebStorage.setItem(UI.getCurrent(), storage, key, value);
    }

    public static void setItem(UI ui, Storage storage, String key, String value) {
        ui.getPage().executeJs("window[$0].setItem($1,$2)", new Serializable[]{storage.toString(), key, value});
    }

    public static void removeItem(String key) {
        WebStorage.removeItem(Storage.localStorage, key);
    }

    public static void removeItem(Storage storage, String key) {
        WebStorage.removeItem(UI.getCurrent(), storage, key);
    }

    public static void removeItem(UI ui, Storage storage, String key) {
        ui.getPage().executeJs("window[$0].removeItem($1)", new Serializable[]{storage.toString(), key});
    }

    public static void clear() {
        WebStorage.clear(Storage.localStorage);
    }

    public static void clear(Storage storage) {
        WebStorage.clear(UI.getCurrent(), storage);
    }

    public static void clear(UI ui, Storage storage) {
        ui.getPage().executeJs("window[$0].clear()", new Serializable[]{storage.toString()});
    }

    public static void getItem(String key, Callback callback) {
        WebStorage.getItem(Storage.localStorage, key, callback);
    }

    public static void getItem(Storage storage, String key, Callback callback) {
        WebStorage.getItem(UI.getCurrent(), storage, key, callback);
    }

    public static void getItem(UI ui, Storage storage, String key, Callback callback) {
        ui.getPage().executeJs("return window[$0].getItem($1);", new Serializable[]{storage.toString(), key}).then(String.class, callback::onValueDetected, (SerializableConsumer & Serializable)s -> callback.onValueDetected(null));
    }

    public static interface Callback {
        public void onValueDetected(String var1);
    }

    public static enum Storage {
        localStorage,
        sessionStorage;

    }
}

