/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.firitin.components.button;

import com.vaadin.flow.component.ClickEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.shared.Registration;
import java.io.Serializable;
import org.vaadin.firitin.fluency.ui.FluentClickNotifier;
import org.vaadin.firitin.fluency.ui.FluentComponent;
import org.vaadin.firitin.fluency.ui.FluentFocusable;
import org.vaadin.firitin.fluency.ui.FluentHasEnabled;
import org.vaadin.firitin.fluency.ui.FluentHasSize;
import org.vaadin.firitin.fluency.ui.FluentHasStyle;
import org.vaadin.firitin.fluency.ui.FluentHasText;
import org.vaadin.firitin.fluency.ui.FluentHasTooltip;
import org.vaadin.firitin.fluency.ui.FluentThemableLayout;
import org.vaadin.firitin.util.VStyleUtil;

public class VButton
extends Button
implements FluentHasSize<VButton>,
FluentHasEnabled<VButton>,
FluentClickNotifier<Button, VButton>,
FluentHasText<VButton>,
FluentFocusable<Button, VButton>,
FluentComponent<VButton>,
FluentHasStyle<VButton>,
FluentThemableLayout<VButton>,
FluentHasTooltip<VButton> {
    private ButtonSize size;
    private ButtonType type;
    private ButtonColor color;

    public VButton() {
    }

    public VButton(Component icon, ComponentEventListener<ClickEvent<Button>> clickListener) {
        super(icon, clickListener);
    }

    public VButton(Component icon, BasicClickListener clickListener) {
        super(icon, (ComponentEventListener & Serializable)e -> clickListener.onClick());
    }

    public VButton(Component icon) {
        super(icon);
    }

    public VButton(String text, Component icon, ComponentEventListener<ClickEvent<Button>> clickListener) {
        super(text, icon, clickListener);
    }

    public VButton(Component icon, String text, ComponentEventListener<ClickEvent<Button>> clickListener) {
        super(text, icon, clickListener);
    }

    public VButton(String text, Component icon, BasicClickListener clickListener) {
        super(text, icon, (ComponentEventListener & Serializable)e -> clickListener.onClick());
    }

    public VButton(String text, Component icon) {
        super(text, icon);
    }

    public VButton(Component icon, String text) {
        super(text, icon);
    }

    public VButton(String text, ComponentEventListener<ClickEvent<Button>> clickListener) {
        super(text, clickListener);
    }

    public VButton(String text, BasicClickListener clickListener) {
        super(text, (ComponentEventListener & Serializable)e -> clickListener.onClick());
    }

    public VButton(String text) {
        super(text);
    }

    public void setType(ButtonType type) {
        this.type = type;
        VStyleUtil.applyOrElse(type, ButtonType.SECONDARY, (HasElement)this);
    }

    public VButton withType(ButtonType type) {
        this.setType(type);
        return this;
    }

    public ButtonType getType() {
        return this.type;
    }

    public void setSize(ButtonSize size) {
        this.size = size;
        VStyleUtil.applyOrElse(size, ButtonSize.NORMAL, (HasElement)this);
    }

    public VButton withSize(ButtonSize size) {
        this.setSize(size);
        return this;
    }

    public ButtonSize getSize() {
        return this.size;
    }

    public void setColor(ButtonColor color) {
        this.color = color;
        VStyleUtil.applyOrElse(color, ButtonColor.NONE, (HasElement)this);
    }

    public VButton withColor(ButtonColor color) {
        this.setColor(color);
        return this;
    }

    public ButtonColor getColor() {
        return this.color;
    }

    public VButton withIcon(Component icon) {
        this.setIcon(icon);
        return this;
    }

    public VButton withIconAfterText(boolean iconAfterText) {
        this.setIconAfterText(iconAfterText);
        return this;
    }

    public VButton withAutofocus(boolean autofocus) {
        this.setAutofocus(autofocus);
        return this;
    }

    public VButton withThemeVariants(ButtonVariant ... variants) {
        this.addThemeVariants((ThemeVariant[])variants);
        return this;
    }

    public Registration addClickListener(BasicClickListener clickListener) {
        return super.addClickListener((ComponentEventListener & Serializable)e -> clickListener.onClick());
    }

    public VButton onClick(BasicClickListener clickListener) {
        super.addClickListener((ComponentEventListener & Serializable)e -> clickListener.onClick());
        return this;
    }

    public static interface BasicClickListener
    extends Serializable {
        public void onClick();
    }

    public static enum ButtonType implements VStyleUtil.ThemeStyle<ButtonType>
    {
        PRIMARY("primary"),
        SECONDARY,
        TERTIARY("tertiary"),
        TERTIARY_INLINE("tertiary-inline");

        private String themeName;

        private ButtonType() {
            this("");
        }

        private ButtonType(String themeName) {
            this.themeName = themeName;
        }

        @Override
        public String getThemeName() {
            return this.themeName;
        }
    }

    public static enum ButtonSize implements VStyleUtil.ThemeStyle<ButtonSize>
    {
        SMALL("small"),
        NORMAL,
        LARGE("large");

        private String size;

        private ButtonSize() {
            this("");
        }

        private ButtonSize(String size) {
            this.size = size;
        }

        @Override
        public String getThemeName() {
            return this.size;
        }
    }

    public static enum ButtonColor implements VStyleUtil.ThemeStyle<ButtonColor>
    {
        NONE,
        CONTRAST("contrast"),
        SUCCESS("success"),
        ERROR("error");

        private String color;

        private ButtonColor() {
            this("");
        }

        private ButtonColor(String color) {
            this.color = color;
        }

        @Override
        public String getThemeName() {
            return this.color;
        }
    }
}

