/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.firitin.components.grid;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.component.button.ButtonVariant;
import com.vaadin.flow.component.contextmenu.ContextMenu;
import com.vaadin.flow.component.contextmenu.MenuItem;
import com.vaadin.flow.component.grid.Grid;
import com.vaadin.flow.component.grid.GridSelectionModel;
import com.vaadin.flow.component.grid.GridVariant;
import com.vaadin.flow.component.icon.VaadinIcon;
import com.vaadin.flow.component.shared.ThemeVariant;
import com.vaadin.flow.data.provider.CallbackDataProvider;
import com.vaadin.flow.data.provider.DataProvider;
import com.vaadin.flow.function.ValueProvider;
import java.io.Serializable;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.vaadin.firitin.fluency.ui.FluentComponent;
import org.vaadin.firitin.fluency.ui.FluentFocusable;
import org.vaadin.firitin.fluency.ui.FluentHasSize;
import org.vaadin.firitin.fluency.ui.FluentHasStyle;
import org.vaadin.firitin.fluency.ui.FluentHasTheme;

public class VGrid<T>
extends Grid<T>
implements FluentComponent<VGrid<T>>,
FluentHasStyle<VGrid<T>>,
FluentHasSize<VGrid<T>>,
FluentFocusable<Grid<T>, VGrid<T>>,
FluentHasTheme<VGrid<T>> {
    public VGrid() {
    }

    public VGrid(int pageSize) {
        super(pageSize);
    }

    public VGrid(Class<T> beanType) {
        super(beanType);
    }

    public VGrid<T> withSelectionMode(Grid.SelectionMode selectionMode) {
        this.setSelectionMode(selectionMode);
        return this;
    }

    public VGrid<T> withSelectionModel(GridSelectionModel<T> selectionModel, Grid.SelectionMode selectionMode) {
        this.setSelectionModel(selectionModel, selectionMode);
        return this;
    }

    public VGrid<T> withProperties(String ... propertyNames) {
        this.setColumns(propertyNames);
        return this;
    }

    public VGrid<T> withThemeVariants(GridVariant ... variants) {
        this.addThemeVariants(variants);
        return this;
    }

    public VGrid<T> setDataProvider(CallbackDataProvider.FetchCallback<T, Void> fetchCallback, CallbackDataProvider.CountCallback<T, Void> countCallback) {
        this.setDataProvider((DataProvider)DataProvider.fromCallbacks(fetchCallback, countCallback));
        return this;
    }

    public VGrid<T> withItems(Collection<T> items) {
        this.setItems(items);
        return this;
    }

    public VGrid<T> withItems(T ... items) {
        this.setItems(items);
        return this;
    }

    @Deprecated
    public void scrollToItem(T item) {
        Stream items;
        try {
            items = this.getListDataView().getItems();
        }
        catch (IllegalStateException exception) {
            items = this.getGenericDataView().getItems();
        }
        AtomicInteger i = new AtomicInteger();
        int index = items.peek(v -> i.incrementAndGet()).anyMatch(itm -> itm.equals(item)) ? i.get() - 1 : -1;
        this.scrollToIndex(index);
    }

    public VGrid<T> withColumnSelector() {
        ContextMenu columnSelector = new ContextMenu();
        this.getColumns().forEach(col -> {
            MenuItem item = (MenuItem)columnSelector.addItem(col.getHeaderText());
            item.setCheckable(true);
            item.setChecked(col.isVisible());
            item.addClickListener((ComponentEventListener & Serializable)e -> {
                col.setVisible(!col.isVisible());
                item.setChecked(col.isVisible());
            });
        });
        Grid.Column fakeColumn = this.addColumn((ValueProvider & Serializable)s -> "");
        fakeColumn.setKey("column-selector-fake-column");
        fakeColumn.setWidth("0px");
        fakeColumn.setFlexGrow(0);
        Button b = new Button((Component)VaadinIcon.CHEVRON_CIRCLE_DOWN_O.create());
        b.addThemeVariants((ThemeVariant[])new ButtonVariant[]{ButtonVariant.LUMO_TERTIARY});
        b.getElement().executeJs("const el = this;\nsetTimeout(() => {\n    const w = el.offsetWidth;\n    el.parentElement.style.overflow = \"visible\";\n    el.parentElement.previousSibling.style.marginRight = (w - 16) + \"px\";\n    el.style.setProperty('margin-left', '-' + (w+16) + 'px');\n}, 0);\n", new Serializable[0]);
        columnSelector.setTarget((Component)b);
        columnSelector.setOpenOnClick(true);
        fakeColumn.setHeader((Component)b);
        return this;
    }
}

