/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.firitin.form;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.introspect.AnnotatedConstructor;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.BasicBeanDescription;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.googlecode.gentyref.GenericTypeReflector;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.HasValue;
import com.vaadin.flow.component.html.Paragraph;
import com.vaadin.flow.component.shared.HasValidationProperties;
import com.vaadin.flow.data.binder.Result;
import com.vaadin.flow.data.binder.ValueContext;
import com.vaadin.flow.data.converter.Converter;
import com.vaadin.flow.data.converter.DefaultConverterFactory;
import com.vaadin.flow.data.value.HasValueChangeMode;
import com.vaadin.flow.data.value.ValueChangeMode;
import com.vaadin.flow.function.SerializableFunction;
import com.vaadin.flow.shared.Registration;
import jakarta.validation.ConstraintViolation;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.vaadin.firitin.form.FormBinderValueChangeEvent;

public class FormBinder<T>
implements HasValue<FormBinderValueChangeEvent<T>, T> {
    private static final ObjectMapper jack = new ObjectMapper();
    private final Class<T> tClass;
    private final BasicBeanDescription bbd;
    Map<BeanPropertyDefinition, HasValue> bpdToEditorField = new HashMap<BeanPropertyDefinition, HasValue>();
    Map<String, HasValue> nameToEditorField = new LinkedHashMap<String, HasValue>();
    Map<String, Converter> nameToConverter = new HashMap<String, Converter>();
    HashMap<String, String> propertyToInputValueConversionError = new HashMap();
    List<Registration> registrations = new ArrayList<Registration>();
    private Set<Component> errorMsgs = new HashSet<Component>();
    private T valueObject;
    private List<HasValue.ValueChangeListener> valueChangeListeners;
    private boolean constraintViolations;
    private HasComponents classLevelViolationDisplay;
    private boolean ignoreServerOriginatedChanges = true;
    private SerializableFunction<String, Component> classLevelValidationViolationComponentProvider = new ParagraphWithErrorStyleClassLevelValidationViolationComponentProvider();

    public FormBinder(Class<T> tClass, Component ... containerComponents) {
        this.tClass = tClass;
        Component[] componentArray = containerComponents[0];
        if (componentArray instanceof HasComponents) {
            HasComponents hc;
            this.classLevelViolationDisplay = hc = (HasComponents)componentArray;
        }
        JavaType javaType = jack.getTypeFactory().constructType(tClass);
        this.bbd = (BasicBeanDescription)jack.getSerializationConfig().introspect(javaType);
        for (Component formComponent : containerComponents) {
            Field[] declaredFields;
            Class<?> aClass = formComponent.getClass();
            for (Field f : declaredFields = aClass.getDeclaredFields()) {
                BeanPropertyDefinition property;
                Class<?> type = f.getType();
                if (!HasValue.class.isAssignableFrom(type) || (property = this.bbd.findProperty(new PropertyName(f.getName()))) == null) continue;
                property.getAccessor().fixAccess(true);
                try {
                    f.setAccessible(true);
                    HasValue hasValue = (HasValue)f.get(formComponent);
                    if (FormBinder.isRequired(property)) {
                        hasValue.setRequiredIndicatorVisible(true);
                    }
                    this.bindProperty(property, hasValue);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    @Deprecated
    public FormBinder(Class<T> tClass, Object editorObject) {
        Field[] declaredFields;
        this.tClass = tClass;
        if (editorObject instanceof HasComponents) {
            HasComponents hc;
            this.classLevelViolationDisplay = hc = (HasComponents)editorObject;
        }
        JavaType javaType = jack.getTypeFactory().constructType(tClass);
        this.bbd = (BasicBeanDescription)jack.getSerializationConfig().introspect(javaType);
        Class<?> aClass = editorObject.getClass();
        for (Field f : declaredFields = aClass.getDeclaredFields()) {
            BeanPropertyDefinition property;
            Class<?> type = f.getType();
            if (!HasValue.class.isAssignableFrom(type) || (property = this.bbd.findProperty(new PropertyName(f.getName()))) == null) continue;
            property.getAccessor().fixAccess(true);
            try {
                f.setAccessible(true);
                HasValue hasValue = (HasValue)f.get(editorObject);
                this.bindProperty(property, hasValue);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public FormBinder(Class<T> tClass, Map<String, HasValue> propertyNameToEditor) {
        this.tClass = tClass;
        JavaType javaType = jack.getTypeFactory().constructType(tClass);
        this.bbd = (BasicBeanDescription)jack.getSerializationConfig().introspect(javaType);
        for (BeanPropertyDefinition property : this.bbd.findProperties()) {
            if (!propertyNameToEditor.containsKey(property.getName())) continue;
            HasValue hasValue = propertyNameToEditor.get(property.getName());
            this.bindProperty(property, hasValue);
        }
    }

    public FormBinder(BasicBeanDescription bdd) {
        this.bbd = bdd;
        this.tClass = this.bbd.getType().getRawClass();
    }

    public FormBinder(T dto, Component ... containerComponents) {
        this(dto.getClass(), containerComponents);
        this.setValue((Class<?>)dto);
    }

    protected static boolean isRequired(BeanPropertyDefinition property) {
        if (property.getPrimaryType().isPrimitive() && property.getRawPrimaryType() != Boolean.TYPE) {
            return true;
        }
        try {
            AnnotatedMember accessor = property.getAccessor();
            return accessor.getAnnotation(NotEmpty.class) != null || accessor.getAnnotation(NotNull.class) != null || accessor.getAnnotation(NotBlank.class) != null;
        }
        catch (NoClassDefFoundError ex) {
            return false;
        }
    }

    protected boolean isReadOnly(BeanPropertyDefinition property) {
        if (!property.hasSetter()) {
            return !this.bbd.isRecordType();
        }
        return false;
    }

    public void bindProperty(BeanPropertyDefinition property, HasValue hasValue) {
        if (FormBinder.isRequired(property)) {
            hasValue.setRequiredIndicatorVisible(true);
        }
        hasValue.setReadOnly(this.isReadOnly(property));
        this.bpdToEditorField.put(property, hasValue);
        this.nameToEditorField.put(property.getName(), hasValue);
        this.configureEditor(property, hasValue);
    }

    protected void configureEditor(BeanPropertyDefinition property, HasValue hasValue) {
        if (hasValue instanceof HasValueChangeMode) {
            HasValueChangeMode hvcm = (HasValueChangeMode)hasValue;
            hvcm.setValueChangeMode(ValueChangeMode.LAZY);
        }
        if (!this.isImmutable()) {
            ValueContext ctx = new ValueContext((Component)hasValue);
            this.registrations.add(hasValue.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
                boolean dropServerOriginateEvent;
                boolean bl = dropServerOriginateEvent = !e.isFromClient() && this.ignoreServerOriginatedChanges;
                if (!dropServerOriginateEvent) {
                    Object value = e.getValue();
                    value = this.convertInputValue(value, property, ctx);
                    try {
                        property.getSetter().callOnWith(this.valueObject, new Object[]{value});
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(ex);
                    }
                }
            }));
        }
        this.registrations.add(hasValue.addValueChangeListener((HasValue.ValueChangeListener & Serializable)e -> {
            if (this.valueChangeListeners != null) {
                FormBinderValueChangeEvent event = new FormBinderValueChangeEvent(this, e.isFromClient());
                for (HasValue.ValueChangeListener vcl : this.valueChangeListeners.toArray(new HasValue.ValueChangeListener[0])) {
                    vcl.valueChanged(event);
                }
            }
        }));
    }

    private Object convertInputValue(Object value, BeanPropertyDefinition property, ValueContext ctx) {
        Converter converter = this.nameToConverter.get(property.getName());
        if (converter != null) {
            Result result = converter.convertToModel(value, ctx);
            try {
                value = result.getOrThrow((SerializableFunction & Serializable)msg -> new RuntimeException(msg.toString()));
                this.propertyToInputValueConversionError.remove(property.getName());
            }
            catch (Throwable ex) {
                value = this.handleInputConversionError(property, ctx, ex.getMessage());
            }
        } else if (value != null) {
            Class<?> presentationValueClass = value.getClass();
            if (property.getPrimaryType().isPrimitive() && value != null) {
                return value;
            }
            if (!property.getPrimaryType().isTypeOrSuperTypeOf(presentationValueClass)) {
                converter = (Converter)DefaultConverterFactory.INSTANCE.newInstance(presentationValueClass, property.getPrimaryType().getRawClass()).orElseThrow(() -> new RuntimeException("No converter found for for " + presentationValueClass + " -> " + property.getPrimaryType()));
                try {
                    value = converter.convertToModel(value, ctx).getOrThrow((SerializableFunction & Serializable)em -> new IllegalArgumentException("Conversion failed" + em));
                }
                catch (Throwable e) {
                    throw new RuntimeException("Conversion failed for " + property.getPrimaryType().getRawClass().getName());
                }
            }
        }
        return value;
    }

    protected Object handleInputConversionError(BeanPropertyDefinition property, ValueContext ctx, String conversionErrorMsg) {
        this.propertyToInputValueConversionError.put(property.getName(), conversionErrorMsg);
        Component component = (Component)ctx.getComponent().get();
        if (component instanceof HasValidationProperties) {
            HasValidationProperties f = (HasValidationProperties)component;
            f.setErrorMessage(conversionErrorMsg);
            f.setInvalid(true);
        }
        return null;
    }

    public T getValue() {
        if (this.isImmutable()) {
            return this.constructRecord();
        }
        if (this.valueObject == null) {
            return this.constructPojo();
        }
        return this.valueObject;
    }

    public void setValue(T valueObject) {
        this.valueObject = valueObject;
        for (BeanPropertyDefinition pd : this.bbd.findProperties()) {
            HasValue hasValue = this.bpdToEditorField.get(pd);
            if (hasValue != null) {
                Object pValue = pd.getAccessor().getValue(valueObject);
                if (pValue == null) {
                    hasValue.clear();
                    continue;
                }
                Converter converter = this.nameToConverter.get(pd.getName());
                if (converter != null) {
                    pValue = converter.convertToPresentation(pValue, new ValueContext((Component)hasValue));
                }
                try {
                    hasValue.setValue(pValue);
                }
                catch (ClassCastException ex) {
                    try {
                        Type fieldValueType = GenericTypeReflector.getTypeParameter(hasValue.getClass(), HasValue.class.getTypeParameters()[1]);
                        Class fieldValueClazz = GenericTypeReflector.erase((Type)fieldValueType);
                        converter = (Converter)DefaultConverterFactory.INSTANCE.newInstance(fieldValueClazz, pd.getPrimaryType().getRawClass()).orElseThrow(() -> new RuntimeException("No converter found for " + pd.getPrimaryType().getRawClass().getName()));
                        Object converted = converter.convertToPresentation(pValue, new ValueContext((Component)hasValue));
                        hasValue.setValue(converted);
                    }
                    catch (Exception e) {
                        new RuntimeException("Conversion failed for " + pd.getPrimaryType().getRawClass().getName(), e);
                    }
                }
                continue;
            }
            Logger.getLogger(FormBinder.class.getName()).log(Level.INFO, "No editor field for property " + pd.getName());
        }
    }

    public FormBinder<T> withValue(T value) {
        this.setValue(value);
        return this;
    }

    public Registration addValueChangeListener(HasValue.ValueChangeListener<? super FormBinderValueChangeEvent<T>> listener) {
        if (this.valueChangeListeners == null) {
            this.valueChangeListeners = new ArrayList<HasValue.ValueChangeListener>();
        }
        this.valueChangeListeners.add(listener);
        return (Registration & Serializable)() -> this.valueChangeListeners.remove(listener);
    }

    public boolean isReadOnly() {
        return false;
    }

    public void setReadOnly(boolean readOnly) {
        throw new UnsupportedOperationException("Not implemented");
    }

    public boolean isRequiredIndicatorVisible() {
        return false;
    }

    public void setRequiredIndicatorVisible(boolean requiredIndicatorVisible) {
        throw new RuntimeException("Not supported");
    }

    protected boolean isImmutable() {
        return this.bbd.isRecordType();
    }

    protected T constructRecord() {
        List constructors = this.bbd.getConstructors();
        AnnotatedConstructor annotatedConstructor = (AnnotatedConstructor)constructors.get(constructors.size() - 1);
        List properties = this.bbd.findProperties();
        Object[] args = new Object[annotatedConstructor.getParameterCount()];
        for (int i = 0; i < annotatedConstructor.getParameterCount(); ++i) {
            BeanPropertyDefinition definition = (BeanPropertyDefinition)properties.get(i);
            HasValue hasValue = this.bpdToEditorField.get(definition);
            Object value = hasValue.getValue();
            args[i] = value = this.convertInputValue(value, definition, new ValueContext((Component)hasValue));
            Class rawType = definition.getGetter().getRawType();
            boolean primitive = definition.getGetter().getRawType().isPrimitive();
            if (!primitive || !hasValue.isRequiredIndicatorVisible() || args[i] != null) continue;
            throw new NullPointerException("Can't construct " + this.bbd.getType().getRawClass().getName() + ", parameter value " + i + " is null!");
        }
        try {
            annotatedConstructor.fixAccess(true);
            return (T)annotatedConstructor.call(args);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected T constructPojo() {
        Object o = this.bbd.instantiateBean(true);
        this.bpdToEditorField.forEach((bpd, hasValue) -> {
            try {
                Object value = hasValue.getValue();
                value = this.convertInputValue(value, (BeanPropertyDefinition)bpd, new ValueContext((Component)hasValue));
                bpd.getSetter().callOnWith(o, new Object[]{value});
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        });
        return (T)o;
    }

    public void setConstraintViolations(Set<ConstraintViolation<T>> violations) {
        this.clearValidationErrors();
        HashSet<ConstraintViolation<T>> nonReported = new HashSet<ConstraintViolation<T>>(violations);
        violations.forEach(cv -> {
            HasValue hasValue;
            String property = cv.getPropertyPath().toString();
            if (!property.isEmpty() && (hasValue = this.nameToEditorField.get(property)) instanceof HasValidationProperties) {
                HasValidationProperties hvp = (HasValidationProperties)hasValue;
                hvp.setInvalid(true);
                hvp.setErrorMessage(cv.getMessage());
                nonReported.remove(cv);
            }
        });
        this.handleClassLevelValidations(nonReported);
        this.constraintViolations = !violations.isEmpty();
    }

    public HasComponents getClassLevelViolationDisplay() {
        if (this.classLevelViolationDisplay != null) {
            return this.classLevelViolationDisplay;
        }
        throw new RuntimeException("No place to report class level violations");
    }

    public void setClassLevelViolationDisplay(HasComponents display) {
        this.classLevelViolationDisplay = display;
    }

    protected void handleClassLevelValidations(Set<ConstraintViolation<T>> violations) {
        for (ConstraintViolation<T> cv : violations) {
            String propertyPath = cv.getPropertyPath().toString();
            this.addClassLevelValidationViolation(this.createClassLevelValidationComponent((String)(propertyPath.isEmpty() ? cv.getMessage() : propertyPath + " " + cv.getMessage())));
        }
    }

    public void setClassLevelValidationViolationComponentProvider(SerializableFunction<String, Component> classLevelValidationViolationComponentProvider) {
        this.classLevelValidationViolationComponentProvider = Objects.requireNonNull(classLevelValidationViolationComponentProvider);
    }

    public void setRawConstraintViolations(Map<String, String> propertyToViolation) {
        this.clearValidationErrors();
        HashMap<String, String> nonReported = new HashMap<String, String>();
        nonReported.putAll(propertyToViolation);
        propertyToViolation.forEach((property, msg) -> {
            HasValue hasValue;
            if (!property.isEmpty() && (hasValue = this.nameToEditorField.get(property)) instanceof HasValidationProperties) {
                HasValidationProperties hvp = (HasValidationProperties)hasValue;
                hvp.setInvalid(true);
                hvp.setErrorMessage(msg);
                nonReported.remove(property);
            }
        });
        this.handleClassLevelValidations(nonReported);
        this.constraintViolations = !propertyToViolation.isEmpty();
    }

    private void handleClassLevelValidations(HashMap<String, String> nonReported) {
        nonReported.forEach((_property, cv) -> this.addClassLevelValidationViolation(this.createClassLevelValidationComponent((String)cv)));
    }

    private Component createClassLevelValidationComponent(String message) {
        return (Component)this.classLevelValidationViolationComponentProvider.apply((Object)message);
    }

    private void addClassLevelValidationViolation(Component validationViolationComponent) {
        HasComponents hc = this.getClassLevelViolationDisplay();
        this.errorMsgs.add(validationViolationComponent);
        hc.add(new Component[]{validationViolationComponent});
    }

    public void clearValidationErrors() {
        this.nameToEditorField.values().forEach(hv -> {
            if (hv instanceof HasValidationProperties) {
                HasValidationProperties hvp = (HasValidationProperties)hv;
                hvp.setInvalid(false);
                hvp.setErrorMessage(null);
            }
        });
        for (Component c : this.errorMsgs) {
            c.removeFromParent();
        }
        this.errorMsgs.clear();
    }

    public void setConverter(String property, Converter<?, ?> strToDt) {
        this.nameToConverter.put(property, strToDt);
    }

    public boolean hasInputConversionErrors() {
        return !this.propertyToInputValueConversionError.isEmpty();
    }

    public Map<String, String> getInputConversionErrors() {
        return this.propertyToInputValueConversionError;
    }

    public boolean isValid() {
        return this.getInputConversionErrors().isEmpty() && this.errorMsgs.isEmpty() && !this.constraintViolations;
    }

    public void setIgnoreServerOriginatedChanges(boolean ignore) {
        this.ignoreServerOriginatedChanges = ignore;
    }

    public void unBind() {
        this.registrations.forEach(Registration::remove);
        this.registrations.clear();
        this.valueObject = null;
    }

    public List<String> getBoundProperties() {
        return this.nameToEditorField.keySet().stream().toList();
    }

    public HasValue getEditor(String property) {
        return this.nameToEditorField.get(property);
    }

    public static class ParagraphWithErrorStyleClassLevelValidationViolationComponentProvider
    implements SerializableFunction<String, Component> {
        public Component apply(String message) {
            Paragraph paragraph = new Paragraph();
            paragraph.addClassNames(new String[]{"text-error"});
            paragraph.setText(message);
            return paragraph;
        }
    }
}

