/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.firitin.util;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.dom.Style;
import in.virit.color.Color;
import java.io.Serializable;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.vaadin.firitin.util.TreeMapStyle;

public class VStyle
implements Style {
    private final Style wrapped;

    public VStyle(Style wrapped) {
        this.wrapped = wrapped;
    }

    public VStyle() {
        this(new TreeMapStyle());
    }

    public static VStyle wrap(Style original) {
        return new VStyle(original);
    }

    public Color getColor() {
        String color = this.wrapped.get("color");
        if (color == null) {
            return null;
        }
        return Color.parseCssColor((String)color);
    }

    public VStyle setColor(Color color) {
        return this.set("color", color.toString());
    }

    public Color getBackgroundColor() {
        String color = this.wrapped.get("background-color");
        if (color == null) {
            return null;
        }
        return Color.parseCssColor((String)color);
    }

    public VStyle setBackgroundColor(Color color) {
        return this.set("background-color", color.toString());
    }

    public String get(String name) {
        return this.wrapped.get(name);
    }

    public VStyle set(String name, String value) {
        this.wrapped.set(name, value);
        return this;
    }

    public VStyle remove(String name) {
        this.wrapped.remove(name);
        return this;
    }

    public VStyle clear() {
        this.wrapped.clear();
        return this;
    }

    public boolean has(String name) {
        return this.wrapped.has(name);
    }

    public Stream<String> getNames() {
        return this.wrapped.getNames();
    }

    public void apply(Component component) {
        for (String name : this.getNames().toList()) {
            String value = this.get(name);
            if (value == null) continue;
            component.getElement().getStyle().set(name, value);
        }
    }

    void apply(Component scope, String cssSelector, boolean applyToShadowRoot) {
        Runnable task = () -> {
            String style = "[" + this.getNames().map(name -> String.format("[\"%s\",\"%s\"]", name, this.get((String)name))).collect(Collectors.joining(",\n")) + "]";
            String querySelectorRoot = applyToShadowRoot ? "this.shadowRoot" : "this";
            scope.getElement().executeJs("const style = %s;\nsetTimeout(() => {\n    const qs = %s.querySelectorAll($0);\n    qs.forEach(el => {\n        style.forEach(r => {\n            el.style.setProperty(r[0], r[1]);\n        });\n    });\n}, 0);\n".formatted(style.toString(), querySelectorRoot), new Serializable[]{cssSelector});
        };
        if (scope.isAttached()) {
            task.run();
        } else {
            scope.addAttachListener((ComponentEventListener & Serializable)event -> {
                task.run();
                event.unregisterListener();
            });
        }
    }

    public void apply(Component component, String cssSelector) {
        this.apply(component, cssSelector, false);
    }

    public void applyToShadowRoot(Component component, String cssSelector) {
        this.apply(component, cssSelector, true);
    }
}

