package org.vaadin.firitin.util.webnotification;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;

import java.net.URI;
import java.time.Instant;
import java.util.List;

/**
 * Represents options for a web notification (mostly autogenerated with ChatGPT).
 * <p>
 * This class provides various properties that can be set to customize the appearance and behavior of a web notification.
 * It includes fields for badge, body, data, direction, icon, image, language, renotify, require interaction,
 * silent mode, tag, timestamp, and vibration patterns.
 * </p>
 * <p>
 * The actions have been left out intentionally, as they are only relevant for web push notifications,
 * that need service worker and those are not supported by Vaadin already.
 * </p>
 */
public class NotificationOptions {

    private static ObjectMapper mapper = new ObjectMapper();
    static {
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }
    private URI badge;
    private String body;
    private Object data;
    private Direction dir;
    private URI icon;
    private URI image;
    private String lang;
    private Boolean renotify;
    private Boolean requireInteraction;
    private Boolean silent;
    private String tag;
    private Instant timestamp;
    private List<Long> vibrate;

    // Constructors
    public NotificationOptions() {
    }

    public URI getBadge() {
        return badge;
    }

    /**
     * @deprecated Badge is not supported by Firefox and Safari, so it is not recommended to use.
     */
    @Deprecated
    public void setBadge(URI badge) {
        this.badge = badge;
    }

    public String getBody() {
        return body;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public Object getData() {
        return data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public Direction getDir() {
        return dir;
    }

    public void setDir(Direction dir) {
        this.dir = dir;
    }

    public URI getIcon() {
        return icon;
    }

    /**
     * @deprecated Icon is not supported by Safari, so it is not recommended to use.
     */
    @Deprecated
    public void setIcon(URI icon) {
        this.icon = icon;
    }

    public URI getImage() {
        return image;
    }

    /**
     * @deprecated Only supported by Chromium-based browsers
     */
    @Deprecated
    public void setImage(URI image) {
        this.image = image;
    }

    public String getLang() {
        return lang;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    public Boolean getRenotify() {
        return renotify;
    }

    /**
     * @deprecated Renotify is not supported by Firefox and Safari, so it is not recommended to use.
     */
    @Deprecated
    public void setRenotify(Boolean renotify) {
        this.renotify = renotify;
    }

    public Boolean getRequireInteraction() {
        return requireInteraction;
    }

    /**
     * @deprecated Require interaction is not supported by Firefox and Safari, so it is not recommended to use.
     */
    @Deprecated
    public void setRequireInteraction(Boolean requireInteraction) {
        this.requireInteraction = requireInteraction;
    }

    public Boolean getSilent() {
        return silent;
    }

    public void setSilent(Boolean silent) {
        this.silent = silent;
    }

    public String getTag() {
        return tag;
    }

    /**
     * @deprecated Tag is not supported by  Safari, so it is not recommended to use.
     */
    @Deprecated
    public void setTag(String tag) {
        this.tag = tag;
    }

    public Instant getTimestamp() {
        return timestamp;
    }

    /**
     * @deprecated Timestamp is not supported by Firefox and Safari, so it is not recommended to use.
     */
    @Deprecated
    public void setTimestamp(Instant timestamp) {
        this.timestamp = timestamp;
    }

    public List<Long> getVibrate() {
        return vibrate;
    }

    /**
     * @deprecated Vibration is not supported by Firefox and Safari, so it is not recommended to use.
     */
    @Deprecated
    public void setVibrate(List<Long> vibrate) {
        this.vibrate = vibrate;
    }

    @Override
    public String toString() {
        try {
            return mapper.writeValueAsString(this);
        } catch (JsonProcessingException e) {
            return "{}";
        }
    }

    public enum Direction {
        AUTO, LTR, RTL
    }

}