/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.firitin.appframework;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasComponents;
import com.vaadin.flow.component.HasText;
import com.vaadin.flow.component.applayout.AppLayout;
import com.vaadin.flow.component.applayout.DrawerToggle;
import com.vaadin.flow.component.html.Footer;
import com.vaadin.flow.component.html.H1;
import com.vaadin.flow.component.html.H2;
import com.vaadin.flow.component.html.Header;
import com.vaadin.flow.component.orderedlayout.FlexComponent;
import com.vaadin.flow.component.orderedlayout.HorizontalLayout;
import com.vaadin.flow.component.orderedlayout.Scroller;
import com.vaadin.flow.dom.Style;
import java.util.Map;
import java.util.Stack;
import java.util.WeakHashMap;
import org.vaadin.firitin.appframework.AdvancedSideNav;
import org.vaadin.firitin.appframework.NavigationItem;
import org.vaadin.firitin.components.orderedlayout.VScroller;
import org.vaadin.firitin.util.style.LumoProps;

public abstract class VAppLayout
extends AppLayout {
    private AdvancedSideNav menu;
    private Footer drawerFooter;
    private H2 viewTitle;
    protected HorizontalLayout navbarHelpers;
    private Stack<Component> viewStack = new Stack();
    private Map<Component, String> explicitViewTitles = new WeakHashMap<Component, String>();
    private Scroller scroller = new VScroller();
    private boolean initialized;

    public VAppLayout() {
        this.setPrimarySection(AppLayout.Section.DRAWER);
    }

    protected abstract Object getDrawerHeader();

    private void addHeaderContent() {
        DrawerToggle toggle = new DrawerToggle();
        toggle.getElement().setAttribute("aria-label", "Menu toggle");
        this.addToNavbar(true, new Component[]{toggle, (Component)this.getViewTitle()});
    }

    @Deprecated(forRemoval=true)
    protected AdvancedSideNav prepareNav() {
        return this.getMenu();
    }

    protected void addDrawerContent() {
        Component content;
        Object headerContent = this.getDrawerHeader();
        if (headerContent instanceof Component) {
            content = (Component)headerContent;
        } else {
            H1 appName = new H1(headerContent.toString());
            appName.getStyle().setMargin(LumoProps.SPACE_M.var());
            appName.getStyle().setFontSize(LumoProps.FONT_SIZE_L.var());
            content = appName;
        }
        Header header = new Header(new Component[]{content});
        this.scroller.setContent((Component)this.prepareNav());
        this.scroller.addClassNames(new String[]{"p-s"});
        this.addToDrawer(new Component[]{header, this.scroller, this.prepareDrawerFooter()});
    }

    public AdvancedSideNav getMenu() {
        if (this.menu == null) {
            this.menu = new AdvancedSideNav();
        }
        return this.menu;
    }

    public Scroller getMenuScroller() {
        return this.scroller;
    }

    @Deprecated
    protected Footer prepareDrawerFooter() {
        return this.getDrawerFooter();
    }

    public Footer getDrawerFooter() {
        if (this.drawerFooter == null) {
            this.drawerFooter = new Footer();
        }
        return this.drawerFooter;
    }

    public void setViewTitle(String title) {
        this.getViewTitle().setText(title);
    }

    public HasText getViewTitle() {
        if (this.viewTitle == null) {
            this.viewTitle = new H2();
            this.viewTitle.addClassNames(new String[]{"text-l", "m-0"});
        }
        return this.viewTitle;
    }

    protected HasComponents getNavbarHelpers() {
        if (this.navbarHelpers == null) {
            this.navbarHelpers = new HorizontalLayout();
            this.navbarHelpers.setAlignItems(FlexComponent.Alignment.BASELINE);
            this.navbarHelpers.getStyle().setPosition(Style.Position.ABSOLUTE);
            this.navbarHelpers.getStyle().setRight(LumoProps.SPACE_M.var());
            this.addToNavbar(true, new Component[]{this.navbarHelpers});
        }
        return this.navbarHelpers;
    }

    public void addNavbarHelper(Component component) {
        this.getNavbarHelpers().add(new Component[]{component});
    }

    protected void updateViewTitle() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.viewStack.size(); ++i) {
            Component component;
            if (i > 0) {
                sb.append(" / ");
            }
            if (this.explicitViewTitles.containsKey(component = (Component)this.viewStack.get(i))) {
                sb.append(this.explicitViewTitles.get(component));
                continue;
            }
            sb.append(NavigationItem.getMenuTextFromClass(component.getClass()));
        }
        this.setViewTitle(sb.toString());
    }

    public void setContent(Component content) {
        if (this.navbarHelpers != null) {
            this.navbarHelpers.removeAll();
        }
        while (this.viewStack.size() > 1) {
            this.closeSubView();
        }
        super.setContent(content);
        this.viewStack.clear();
        this.viewStack.push(content);
    }

    public void openSubView(Component component, String viewTitle) {
        this.viewStack.push(component);
        if (viewTitle != null) {
            this.explicitViewTitles.put(component, viewTitle);
        }
        super.setContent(component);
        this.updateViewTitle();
    }

    public void openSubView(Component component) {
        this.openSubView(component, null);
    }

    public void closeSubView(Component component) {
        Component pop = this.viewStack.pop();
        if (pop != component) {
            throw new IllegalStateException();
        }
        if (pop == null) {
            throw new IllegalStateException();
        }
        this.explicitViewTitles.remove(pop);
        super.setContent(this.viewStack.peek());
        this.updateViewTitle();
    }

    public void closeSubView() {
        Component pop = this.viewStack.pop();
        if (pop == null) {
            throw new IllegalStateException();
        }
        this.explicitViewTitles.remove(pop);
        super.setContent(this.viewStack.peek());
        this.updateViewTitle();
    }

    protected void afterNavigation() {
        System.out.println("VAppLayout afterNavigation");
        super.afterNavigation();
        if (!this.initialized) {
            this.addDrawerContent();
            this.addHeaderContent();
            this.initialized = true;
        }
        this.updateViewTitle();
    }
}

