/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.firitin.components.upload;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.ComponentEvent;
import com.vaadin.flow.component.ComponentEventListener;
import com.vaadin.flow.component.DetachEvent;
import com.vaadin.flow.component.DomEvent;
import com.vaadin.flow.component.EventData;
import com.vaadin.flow.component.HasElement;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.dependency.Uses;
import com.vaadin.flow.component.shared.SlotUtils;
import com.vaadin.flow.component.upload.Upload;
import com.vaadin.flow.component.upload.UploadI18N;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.internal.JsonSerializer;
import com.vaadin.flow.server.Command;
import com.vaadin.flow.server.VaadinRequest;
import com.vaadin.flow.server.VaadinResponse;
import com.vaadin.flow.server.VaadinSession;
import com.vaadin.flow.server.streams.ElementRequestHandler;
import com.vaadin.flow.shared.Registration;
import elemental.json.JsonObject;
import elemental.json.JsonType;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Serializable;
import java.net.URLDecoder;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.vaadin.firitin.fluency.ui.FluentComponent;
import org.vaadin.firitin.fluency.ui.FluentHasEnabled;
import org.vaadin.firitin.fluency.ui.FluentHasSize;
import org.vaadin.firitin.fluency.ui.FluentHasStyle;

@Uses(value=Upload.class)
@Tag(value="vaadin-upload")
public class UploadFileHandler
extends Component
implements FluentComponent<UploadFileHandler>,
FluentHasStyle<UploadFileHandler>,
FluentHasSize<UploadFileHandler>,
FluentHasEnabled<UploadFileHandler> {
    private UploadI18N i18n;
    private int maxFiles = 1;
    private boolean splitToChunks = false;
    private int maxChunkSize = 0x100000;
    protected final CallbackFileHandler fileHandler;
    private FileRequestHandler frh;
    private boolean clearAutomatically = true;
    private UI ui;
    private int maxConcurrentUploads = 1;
    private FileDetails activeUpload;
    private long bytesRead = 0L;
    PipedOutputStream pos;
    PipedInputStream pis;

    @Deprecated(forRemoval=false)
    public UploadFileHandler chunked() {
        this.splitToChunks = true;
        return this;
    }

    @Deprecated(forRemoval=false)
    public UploadFileHandler withChunkSize(int maxChunkSize) {
        this.splitToChunks = true;
        this.maxChunkSize = maxChunkSize;
        return this;
    }

    public UploadFileHandler(FileHandler fileHandler) {
        this((InputStream content, FileDetails fmd) -> {
            fileHandler.handleFile(content, fmd.fileName(), fmd.mimeType());
            return (Command & Serializable)() -> {};
        });
    }

    public UploadFileHandler(CallbackFileHandler fileHandler) {
        this.fileHandler = fileHandler;
        this.withAllowMultiple(false);
        this.addUploadSucceededListener((ComponentEventListener<UploadSucceededEvent>)(ComponentEventListener & Serializable)e -> {});
    }

    public void clearFiles() {
        this.getElement().executeJs("this.files = [];", new Serializable[0]);
    }

    public UploadFileHandler allowMultiple() {
        return this.withAllowMultiple(true);
    }

    public UploadFileHandler withAllowMultiple(boolean allowMultiple) {
        if (allowMultiple) {
            this.withMaxFiles(Integer.MAX_VALUE);
        } else {
            this.withMaxFiles(1);
        }
        return this;
    }

    public UploadFileHandler withDragAndDrop(boolean enableDragAndDrop) {
        if (enableDragAndDrop) {
            this.getElement().removeAttribute("nodrop");
        } else {
            this.getElement().setAttribute("nodrop", true);
        }
        return this;
    }

    public UploadFileHandler withClearAutomatically(boolean clear) {
        this.clearAutomatically = clear;
        return this;
    }

    protected void onAttach(AttachEvent attachEvent) {
        this.frh = new FileRequestHandler();
        this.getElement().setAttribute("target", (ElementRequestHandler)this.frh);
        this.getElement().executeJs("    // override default dragover so that it works\n    this.addEventListener(\"dragover\", event => {\n        event.stopPropagation();\n        event.preventDefault();\n        if (!this.nodrop && !this._dragover) {\n            let containsInvalid = false;\n            let numberOfFiles = 0;\n            const re = this.__acceptRegexp;\n            for (const item of event.dataTransfer.items) {\n                const acceptedType = (re == null) || re.test(item.type);\n                if(acceptedType && item.kind == \"file\") {\n                    numberOfFiles++;\n                } else {\n                    containsInvalid = true;\n                }\n            }\n            if(!containsInvalid && (this.files.length + numberOfFiles) <= this.maxFiles) {\n                this._dragoverValid = !this.maxFilesReached;\n                this._dragover = true;\n            }\n        }\n        event.dataTransfer.dropEffect = !this._dragoverValid || this.nodrop ? 'none' : 'copy';\n    }, true); // bubling phase as no idea how to override default handler by default\n\n    // avoid the default auto upload behaviour\n    // that immediately opens xhr for each file\n    this.noAuto = true;\n    const CLEAR = $0;\n    const MAX_CONNECTIONS = $1;\n    const SEND_AS_CHUNKS = $2;\n    const MAX_CHUNK_SIZE = $3;\n    this.queueNext = () => {\n        const numConnections = this.files.filter(file => file.uploading).length;\n        if(numConnections < MAX_CONNECTIONS) {\n        // reverse to pick next in selection order\n            const nextFileToUpload = this.files.slice().reverse().find(file => file.held)\n            if (nextFileToUpload) {\n                this.uploadFiles(nextFileToUpload)\n            }\n        }\n    }\n\n    // start uploading next file in queue when a file is successfully uploaded\n    this.addEventListener('upload-success', e => {\n        if(CLEAR) {\n            const index = this.files.indexOf(e.detail.file);\n            if (index > -1) {\n                this._removeFile(e.detail.file);\n            }\n        }\n        this.queueNext();\n    });\n\n    // start uploading next file in queue also when there is an error when uploading the file\n    this.addEventListener('upload-error', e => {\n        console.error(\"Upload error for file: \" + e.detail.file.name, e.detail.error);\n        const isSafari = /^((?!chrome|android).)*safari/i.test(navigator.userAgent);\n        // http2, safari && xhr, status codes not available for 413 (although one sees it via inspector) !!!\n        const safariIsWeirdWithHttp2AndXhr = isSafari && e.detail.xhr.status === 0 && e.detail.xhr.responseText === \"\";\n        // if e.g. front proxy rejects too large file (std error code 413), try sending as chunks\n        if(e.detail.xhr.status === 413 || safariIsWeirdWithHttp2AndXhr) {\n            event.preventDefault(); // prevent the default upload error handling\n            event.stopPropagation();\n            console.warn(\"Upload failed with status 413, trying to upload as chunks instead.\");\n            const file = event.detail.file;\n            const name = encodeURIComponent(file.name);\n            const folderPath = encodeURIComponent(file.webkitRelativePath ? (\"/\" + file.webkitRelativePath) : file.__folderPath);\n            const cd = 'name=upload;attachment;filename=\"'+ name + '\"' + ';folderPath=\"' + folderPath + '\"';\n            this.__sendAsChunks(file, cd);\n            return;\n        } else {\n            this.queueNext();\n        }\n    });\n\n    this.addEventListener('files-changed', (event) => {\n        this.queueNext();\n    });\n\n    // This sends the request without obsolete and somewhat problematic multipart request\n    this.addEventListener(\"upload-request\", e => {\n        e.preventDefault(true); // I'll send this instead!!\n        const file = event.detail.file;\n        const name = encodeURIComponent(file.name);\n        const folderPath = encodeURIComponent(file.webkitRelativePath ? (\"/\" + file.webkitRelativePath) : file.__folderPath);\n        const cd = 'name=upload;attachment;filename=\"'+ name + '\"' + ';folderPath=\"' + folderPath + '\"';\n        if(SEND_AS_CHUNKS) {\n            // This splits the file to chunks and uploads them one by one\n            this.__sendAsChunks(file, cd);\n        } else {\n            // This mosly relies the default behaviour, just not using multipart request\n            const xhr = event.detail.xhr;\n            xhr.setRequestHeader('Content-Type', file.type);\n            xhr.setRequestHeader('Content-Disposition', cd);\n            xhr.send(file);\n        }\n    });\n\n    async function uploadChunk(url, chunk, offset, total, cd, retries = 3) {\n      try {\n        return await fetch(url, {\n          method: 'POST',\n          headers: {\n            \"Chunk-Offset\": offset,\n            \"Total-File-Size\": total,\n            \"Content-Disposition\": cd,\n          },\n          body: chunk,\n        });\n      } catch (error) {\n        if (retries > 0) {\n          return await uploadChunk(chunk, retries - 1);\n        } else {\n          console.error('Failed to upload chunk: ', error);\n        }\n      }\n    }\n\n    this.__sendAsChunks = (file, cd) => {\n        const chunkSize = Math.min(file.size, MAX_CHUNK_SIZE);\n        let offset = 0;\n        file.status = this.__effectiveI18n.uploading.status.connecting;\n        file.uploading = file.indeterminate = true;\n        file.complete = file.abort = file.error = file.held = false;\n        this._renderFileList();\n\n        const ini = Date.now();\n        let stalledId, last;\n\n        const sendNextChunk = () => {\n            if (offset < file.size) {\n                const chunk = file.slice(offset, offset + chunkSize);\n                console.debug(\"Uploading chunk of size \" + chunk.size + \" at offset \" + offset);\n                uploadChunk(file.uploadTarget, chunk, offset, file.size, cd).then(r => {\n                    if(r.ok) {\n                        console.debug(\"Chunk uploaded successfully\");\n                    } else {\n                        // stop uploading this file\n                        file.error = \"Server error: \" + r.status + \" \" + r.statusText;\n                        file.indeterminate = file.status = undefined;\n                        this._renderFileList();\n                        return;\n                    }\n                    offset += chunkSize;\n\n                    clearTimeout(stalledId);\n\n                    last = Date.now();\n                    const elapsed = (last - ini) / 1000;\n                    const loaded = offset,\n                      total = file.size,\n                      progress = ~~((loaded / total) * 100);\n                    file.loaded = loaded;\n                    file.progress = progress;\n                    file.indeterminate = loaded <= 0 || loaded >= total;\n\n                    if (file.error) {\n                      file.indeterminate = file.status = undefined;\n                    } else if (!file.abort) {\n                      if (progress < 100) {\n                        this._setStatus(file, total, loaded, elapsed);\n                        stalledId = setTimeout(() => {\n                          file.status = this.__effectiveI18n.uploading.status.stalled;\n                          this._renderFileList();\n                        }, 2000);\n                      } else {\n                        file.loadedStr = file.totalStr;\n                        file.status = this.__effectiveI18n.uploading.status.processing;\n                      }\n                    }\n\n                    this._renderFileList();\n                    this.dispatchEvent(new CustomEvent('upload-progress', { detail: { file } }));\n\n                    sendNextChunk();\n                }).catch(error => {\n                    console.error('Error uploading chunk:', error);\n                    this.dispatchEvent(new CustomEvent('upload-error', {\n                        detail: { file: file, error: error }\n                    }));\n                    this._renderFileList();\n                });\n            } else {\n                // All chunks uploaded, notify the server\n                console.debug(\"All chunks uploaded for file: \" + file.name);\n                file.complete = true; // mark the file as complete\n                this.dispatchEvent(new CustomEvent('upload-success', {\n                    detail: { file: file }\n                }));\n            }\n        };\n        sendNextChunk();\n    }\n\n    this.__getFilesFromDropEvent = (dropEvent) => {\n      async function getFilesFromEntry(entry) {\n        if (entry.isFile) {\n          return new Promise((resolve) => {\n            // In case of an error, resolve without any files\n            entry.file(resolve, () => resolve([]));\n          });\n        } else if (entry.isDirectory) {\n          const reader = entry.createReader();\n          const entries = await new Promise((resolve) => {\n            // In case of an error, resolve without any files\n            reader.readEntries(resolve, () => resolve([]));\n          });\n          const files = await Promise.all(entries.map(getFilesFromEntry));\n          for (let i = 0; i < files.length; i++) {\n            files[i].__folderPath = entry.fullPath + '/' + files[i].name;\n          }\n          return files.flat();\n        }\n      }\n\n      // In some cases (like dragging attachments from Outlook on Windows), \"webkitGetAsEntry\"\n      // can return null for \"dataTransfer\" items. Also, there is no reason to check for\n      // \"webkitGetAsEntry\" when there are no folders. Therefore, \"dataTransfer.files\" is used\n      // to handle such cases.\n      const containsFolders = Array.from(dropEvent.dataTransfer.items)\n        .filter((item) => !!item)\n        .filter((item) => typeof item.webkitGetAsEntry === 'function')\n        .map((item) => item.webkitGetAsEntry())\n        .some((entry) => !!entry && entry.isDirectory);\n      if (!containsFolders) {\n        return Promise.resolve(dropEvent.dataTransfer.files ? Array.from(dropEvent.dataTransfer.files) : []);\n      }\n\n      const filePromises = Array.from(dropEvent.dataTransfer.items)\n        .map((item) => item.webkitGetAsEntry())\n        .filter((entry) => !!entry)\n        .map(getFilesFromEntry);\n\n      return Promise.all(filePromises).then((files) => files.flat());\n    };\n", new Serializable[]{Boolean.valueOf(this.clearAutomatically), Integer.valueOf(this.maxConcurrentUploads), Boolean.valueOf(this.splitToChunks), Integer.valueOf(this.maxChunkSize)});
        this.ui = attachEvent.getUI();
        super.onAttach(attachEvent);
        if (this.i18n != null) {
            this.setI18nWithJS();
        }
    }

    protected void onDetach(DetachEvent detachEvent) {
        this.ui = null;
        super.onDetach(detachEvent);
    }

    public UploadFileHandler withMaxFiles(int maxFiles) {
        this.maxFiles = maxFiles;
        this.getElement().setProperty("maxFiles", (double)maxFiles);
        return this;
    }

    public Registration addUploadSucceededListener(ComponentEventListener<UploadSucceededEvent> listener) {
        return this.addListener(UploadSucceededEvent.class, listener);
    }

    public void setMaxConcurrentUploads(int maxConcurrentUploads) {
        this.maxConcurrentUploads = maxConcurrentUploads;
    }

    public void setUploadButton(Component button) {
        SlotUtils.setSlot((HasElement)this, (String)"add-button", (Component[])new Component[]{button});
    }

    public UploadFileHandler withUploadButton(Component button) {
        this.setUploadButton(button);
        return this;
    }

    public void setAcceptedFileTypes(String ... acceptedFileTypes) {
        String accepted = "";
        if (acceptedFileTypes != null) {
            accepted = String.join((CharSequence)",", acceptedFileTypes);
        }
        this.getElement().setProperty("accept", accepted);
    }

    public UploadFileHandler withAcceptedFileTypes(String ... acceptedFileTypes) {
        this.setAcceptedFileTypes(acceptedFileTypes);
        return this;
    }

    public void setDropLabel(Component label) {
        SlotUtils.setSlot((HasElement)this, (String)"drop-label", (Component[])new Component[]{label});
    }

    public UploadFileHandler withDropLabel(Component label) {
        this.setDropLabel(label);
        return this;
    }

    public void setDropLabelIcon(Component icon) {
        SlotUtils.setSlot((HasElement)this, (String)"drop-label-icon", (Component[])new Component[]{icon});
    }

    public UploadFileHandler withDropLabelIcon(Component icon) {
        this.setDropLabelIcon(icon);
        return this;
    }

    public UploadFileHandler chooseFolders() {
        this.allowMultiple();
        this.getElement().executeJs("    this.shadowRoot.querySelector(\"input\").webkitdirectory = true;\n", new Serializable[0]);
        return this;
    }

    public void setI18n(UploadI18N i18n) {
        Objects.requireNonNull(i18n, "The I18N properties object should not be null");
        this.i18n = i18n;
        this.runBeforeClientResponse((SerializableConsumer<UI>)(SerializableConsumer & Serializable)ui -> {
            if (i18n == this.i18n) {
                this.setI18nWithJS();
            }
        });
    }

    private void setI18nWithJS() {
        JsonObject i18nJson = (JsonObject)JsonSerializer.toJson((Object)this.i18n);
        this.deeplyRemoveNullValuesFromJsonObject(i18nJson);
        this.getElement().executeJs("const dropFiles = Object.assign({}, this.i18n.dropFiles, $0.dropFiles);const addFiles = Object.assign({}, this.i18n.addFiles, $0.addFiles);const error = Object.assign({}, this.i18n.error, $0.error);const uploadingStatus = Object.assign({}, this.i18n.uploading.status, $0.uploading && $0.uploading.status);const uploadingRemainingTime = Object.assign({}, this.i18n.uploading.remainingTime, $0.uploading && $0.uploading.remainingTime);const uploadingError = Object.assign({}, this.i18n.uploading.error, $0.uploading && $0.uploading.error);const uploading = {status: uploadingStatus,  remainingTime: uploadingRemainingTime,  error: uploadingError};const units = $0.units || this.i18n.units;this.i18n = Object.assign({}, this.i18n, $0, {  addFiles: addFiles,  dropFiles: dropFiles,  uploading: uploading, units: units});", new Serializable[]{i18nJson});
    }

    private void deeplyRemoveNullValuesFromJsonObject(JsonObject jsonObject) {
        for (String key : jsonObject.keys()) {
            if (jsonObject.get(key).getType() == JsonType.OBJECT) {
                this.deeplyRemoveNullValuesFromJsonObject((JsonObject)jsonObject.get(key));
                continue;
            }
            if (jsonObject.get(key).getType() != JsonType.NULL) continue;
            jsonObject.remove(key);
        }
    }

    void runBeforeClientResponse(SerializableConsumer<UI> command) {
        this.getElement().getNode().runWhenAttached((SerializableConsumer & Serializable)ui -> ui.beforeClientResponse((Component)this, (SerializableConsumer & Serializable)context -> command.accept(ui)));
    }

    public void onEnabledStateChanged(boolean enabled) {
        super.onEnabledStateChanged(enabled);
        if (!enabled) {
            int origMax = this.maxFiles;
            this.withMaxFiles(0);
            this.maxFiles = origMax;
        } else {
            this.withMaxFiles(this.maxFiles);
        }
    }

    @FunctionalInterface
    public static interface FileHandler
    extends Serializable {
        public void handleFile(InputStream var1, String var2, String var3);
    }

    @FunctionalInterface
    public static interface CallbackFileHandler
    extends Serializable {
        public Command handleFile(InputStream var1, FileDetails var2) throws IOException;
    }

    private class FileRequestHandler
    implements ElementRequestHandler {
        private FileRequestHandler() {
        }

        public String getUrlPostfix() {
            return "upload";
        }

        public void handleRequest(VaadinRequest request, VaadinResponse response, VaadinSession session, Element owner) throws IOException {
            String cl = request.getHeader("Content-Length");
            String cd = request.getHeader("Content-Disposition");
            String contentType = request.getHeader("Content-Type");
            String chunkOffset = request.getHeader("Chunk-Offset");
            String totalSize = request.getHeader("Total-File-Size");
            String folderPath = null;
            String name = cd.split(";")[2].split("=")[1].substring(1);
            name = name.substring(0, name.indexOf("\""));
            name = URLDecoder.decode(name, "UTF-8");
            if (cd.contains("folderPath")) {
                folderPath = cd.split(";")[3].split("=")[1].substring(1);
                if ("undefined".equals(folderPath = URLDecoder.decode(folderPath.substring(0, folderPath.indexOf("\"")), "UTF-8"))) {
                    folderPath = null;
                }
            }
            long fileSize = totalSize == null ? Long.parseLong(cl) : Long.parseLong(totalSize);
            FileDetails metaData = new FileDetails(name, contentType, fileSize, folderPath);
            if (chunkOffset != null) {
                long offset = Long.parseLong(chunkOffset);
                if (offset == 0L) {
                    if (UploadFileHandler.this.activeUpload != null) {
                        throw new IllegalStateException("Already uploading a file, cannot start a new one!");
                    }
                    UploadFileHandler.this.activeUpload = metaData;
                    UploadFileHandler.this.bytesRead = 0L;
                    UploadFileHandler.this.pos = new PipedOutputStream();
                    UploadFileHandler.this.pis = new PipedInputStream(UploadFileHandler.this.pos);
                    Executor executor = session.getService().getExecutor();
                    executor.execute(() -> {
                        try {
                            Command command = UploadFileHandler.this.fileHandler.handleFile(UploadFileHandler.this.pis, metaData);
                            UploadFileHandler.this.ui.access(command);
                            UploadFileHandler.this.pis.close();
                        }
                        catch (Exception e) {
                            try {
                                UploadFileHandler.this.pis.close();
                                UploadFileHandler.this.pos.close();
                            }
                            catch (IOException ex) {
                                throw new RuntimeException(ex);
                            }
                            throw new RuntimeException(e);
                        }
                    });
                } else {
                    if (!metaData.equals(UploadFileHandler.this.activeUpload)) {
                        throw new IllegalStateException("Cannot upload chunk for a different file than the one started earlier! Expected: " + String.valueOf(UploadFileHandler.this.activeUpload) + ", but got: " + String.valueOf(metaData));
                    }
                    if (offset != UploadFileHandler.this.bytesRead) {
                        throw new IllegalStateException("Chunk offset is not correct! Expected: " + UploadFileHandler.this.bytesRead + ", but got: " + offset);
                    }
                }
                InputStream content = request.getInputStream();
                content.transferTo(UploadFileHandler.this.pos);
                UploadFileHandler.this.bytesRead += Long.parseLong(cl);
                if (UploadFileHandler.this.bytesRead >= fileSize) {
                    UploadFileHandler.this.activeUpload = null;
                    UploadFileHandler.this.pos.close();
                }
            } else {
                Command cb = UploadFileHandler.this.fileHandler.handleFile(request.getInputStream(), metaData);
                if (cb != null) {
                    UploadFileHandler.this.ui.access(cb);
                }
            }
            response.setStatus(200);
            response.getWriter().println("OK");
        }
    }

    @DomEvent(value="upload-success")
    public static class UploadSucceededEvent
    extends ComponentEvent<UploadFileHandler> {
        private final String fileName;

        public UploadSucceededEvent(UploadFileHandler source, boolean fromClient, @EventData(value="event.detail.file.name") String fileName) {
            super((Component)source, fromClient);
            this.fileName = fileName;
        }

        public String getFileName() {
            return this.fileName;
        }
    }

    public record FileDetails(String fileName, String mimeType, long contentLenght, String folderPath) {
    }
}

