/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.firitin.devicemotion;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.component.button.Button;
import com.vaadin.flow.dom.DomEventListener;
import com.vaadin.flow.dom.ElementAttachListener;
import java.io.Serializable;

public class DeviceSensorPermissions {
    public static Button createRequestPermissionButton(String buttonText, SensorType sensorType, Runnable onSuccess, Runnable onError) {
        Button button = new Button(buttonText);
        DeviceSensorPermissions.configurePermissionRequest(button, sensorType, onSuccess, onError);
        return button;
    }

    public static void configurePermissionRequest(Button button, SensorType sensorType, Runnable onSuccess, Runnable onError) {
        UI ui = UI.getCurrent();
        String jsCode = DeviceSensorPermissions.generatePermissionRequestJS(sensorType);
        button.getElement().executeJs("const btn = this;\nconst originalClick = btn.onclick;\n\n// Store callbacks on the element\nbtn._permissionSuccess = () => {\n    $0.$server.onPermissionGranted();\n};\nbtn._permissionError = () => {\n    $1.$server.onPermissionDenied();\n};\n\n// Override click to handle permissions first\nbtn.addEventListener('click', async function(e) {\n    // Check if permissions are needed\n    const needsMotion = typeof DeviceMotionEvent !== 'undefined' &&\n                       typeof DeviceMotionEvent.requestPermission === 'function';\n    const needsOrientation = typeof DeviceOrientationEvent !== 'undefined' &&\n                            typeof DeviceOrientationEvent.requestPermission === 'function';\n\n    const sensorType = $2;\n\n    if (!needsMotion && !needsOrientation) {\n        // No permissions needed, proceed directly\n        btn._permissionSuccess();\n        return;\n    }\n\n    try {\n        // Request permissions based on sensor type\n        if (sensorType === 'BOTH' || sensorType === 'MOTION') {\n            if (needsMotion) {\n                const motionState = await DeviceMotionEvent.requestPermission();\n                if (motionState !== 'granted') {\n                    btn._permissionError();\n                    return;\n                }\n            }\n        }\n\n        if (sensorType === 'BOTH' || sensorType === 'ORIENTATION') {\n            if (needsOrientation) {\n                const orientationState = await DeviceOrientationEvent.requestPermission();\n                if (orientationState !== 'granted') {\n                    btn._permissionError();\n                    return;\n                }\n            }\n        }\n\n        // All permissions granted\n        btn._permissionSuccess();\n    } catch (error) {\n        console.error('Permission request failed:', error);\n        btn._permissionError();\n    }\n});\n", new Serializable[]{button.getElement(), button.getElement(), sensorType.name()});
        button.getElement().addAttachListener((ElementAttachListener & Serializable)event -> ui.getPage().executeJs("const btn = $0;\nbtn.$server = {\n    onPermissionGranted: () => {\n        btn.dispatchEvent(new CustomEvent('permission-granted'));\n    },\n    onPermissionDenied: () => {\n        btn.dispatchEvent(new CustomEvent('permission-denied'));\n    }\n};\n", new Serializable[]{button.getElement()}));
        button.getElement().addEventListener("permission-granted", (DomEventListener & Serializable)e -> {
            if (onSuccess != null) {
                onSuccess.run();
            }
        });
        button.getElement().addEventListener("permission-denied", (DomEventListener & Serializable)e -> {
            if (onError != null) {
                onError.run();
            }
        });
    }

    public static boolean isPermissionRequired(UI ui, SensorType sensorType) {
        String jsCheck = switch (sensorType) {
            default -> throw new IncompatibleClassChangeError();
            case SensorType.MOTION -> "return typeof DeviceMotionEvent !== 'undefined' &&\n       typeof DeviceMotionEvent.requestPermission === 'function';\n";
            case SensorType.ORIENTATION -> "return typeof DeviceOrientationEvent !== 'undefined' &&\n       typeof DeviceOrientationEvent.requestPermission === 'function';\n";
            case SensorType.BOTH -> "return (typeof DeviceMotionEvent !== 'undefined' &&\n        typeof DeviceMotionEvent.requestPermission === 'function') ||\n       (typeof DeviceOrientationEvent !== 'undefined' &&\n        typeof DeviceOrientationEvent.requestPermission === 'function');\n";
        };
        return (Boolean)ui.getPage().executeJs(jsCheck, new Serializable[0]).toCompletableFuture(Boolean.class).join();
    }

    private static String generatePermissionRequestJS(SensorType sensorType) {
        return switch (sensorType) {
            default -> throw new IncompatibleClassChangeError();
            case SensorType.MOTION -> "DeviceMotionEvent.requestPermission()";
            case SensorType.ORIENTATION -> "DeviceOrientationEvent.requestPermission()";
            case SensorType.BOTH -> "Promise.all([\n    DeviceMotionEvent.requestPermission(),\n    DeviceOrientationEvent.requestPermission()\n])\n";
        };
    }

    public static enum SensorType {
        MOTION,
        ORIENTATION,
        BOTH;

    }
}

