/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.firitin.util.webnotification;

import com.vaadin.flow.component.UI;
import com.vaadin.flow.function.SerializableConsumer;
import com.vaadin.flow.server.Command;
import java.io.Serializable;
import java.util.concurrent.CompletableFuture;
import org.vaadin.firitin.util.webnotification.NotificationOptions;

public class WebNotification {
    private final UI ui;

    public static WebNotification get() {
        return new WebNotification(UI.getCurrent());
    }

    public WebNotification(UI ui) {
        this.ui = ui;
    }

    public void showNotification(String msg, NotificationOptions options) {
        this.ui.getPage().executeJs("    const options = %s;\n    new Notification($0, options);\n".formatted(options), new Serializable[]{msg});
    }

    public void showNotification(String msg) {
        this.ui.getPage().executeJs("    new Notification($0);\n", new Serializable[]{msg});
    }

    public void showNotificationAsync(String msg) {
        this.ui.access((Command & Serializable)() -> this.showNotification(msg));
    }

    public void showNotificationAsync(String msg, NotificationOptions options) {
        this.ui.access((Command & Serializable)() -> this.showNotification(msg, options));
    }

    public CompletableFuture<Permission> checkPermission() {
        return this.ui.getPage().executeJs("    return Notification.permission;\n", new Serializable[0]).toCompletableFuture(String.class).thenApply(str -> Permission.valueOf(str.toUpperCase()));
    }

    public void requestPermission(Runnable onSuccess, Runnable onError) {
        this.ui.getPage().executeJs("    return Notification.requestPermission();\n", new Serializable[0]).then(String.class, (SerializableConsumer & Serializable)str -> {
            Permission permission = Permission.valueOf(str.toUpperCase());
            if (permission == Permission.GRANTED) {
                onSuccess.run();
            } else {
                onError.run();
            }
        }, (SerializableConsumer & Serializable)error -> onError.run());
    }

    public static enum Permission {
        DEFAULT,
        GRANTED,
        DENIED;

    }
}

