/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.firitin.appframework;

import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.icon.Icon;
import com.vaadin.flow.component.sidenav.SideNavItem;
import com.vaadin.flow.dom.Style;
import com.vaadin.flow.router.PageTitle;
import java.lang.annotation.Annotation;
import org.apache.commons.lang3.StringUtils;
import org.vaadin.firitin.appframework.MenuItem;

public class NavigationItem
extends SideNavItem {
    private final Class<? extends Component> navigationTarget;
    private final String text;
    private String path;
    private boolean disabled = false;

    public NavigationItem(Class<? extends Component> navigationTarget) {
        super(null, navigationTarget);
        this.getStyle().setDisplay(Style.Display.BLOCK);
        this.text = NavigationItem.getMenuTextFromClass(navigationTarget);
        this.setLabel(this.text);
        MenuItem me = navigationTarget.getAnnotation(MenuItem.class);
        if (me != null) {
            if (me.icon() != null) {
                this.setPrefixComponent((Component)new Icon(me.icon()));
            }
            if (!me.enabled()) {
                this.setEnabled(false);
            }
        }
        this.navigationTarget = navigationTarget;
    }

    public static String getMenuTextFromClass(Class<? extends Component> navigationTarget) {
        String text;
        MenuItem me = NavigationItem.getAnnotationFromType(navigationTarget, MenuItem.class);
        if (me != null && !me.title().isEmpty()) {
            text = me.title();
        } else {
            PageTitle title = NavigationItem.getAnnotationFromType(navigationTarget, PageTitle.class);
            if (title == null) {
                String simpleName = navigationTarget.getSimpleName();
                if (simpleName.endsWith("_Subclass")) {
                    simpleName = simpleName.substring(0, simpleName.length() - "_Subclass".length());
                }
                if (simpleName.endsWith("View")) {
                    simpleName = simpleName.substring(0, simpleName.length() - 4);
                }
                text = StringUtils.join((Object[])StringUtils.splitByCharacterTypeCamelCase((String)simpleName), (char)' ');
            } else {
                text = title.value();
            }
        }
        return text;
    }

    private static <A extends Annotation> A getAnnotationFromType(Class<?> classType, Class<A> annotationClass) {
        while (!classType.getName().equals(Object.class.getName())) {
            if (classType.isAnnotationPresent(annotationClass)) {
                return classType.getAnnotation(annotationClass);
            }
            classType = classType.getSuperclass();
        }
        return null;
    }

    public String getText() {
        return this.text;
    }

    public Class<? extends Component> getNavigationTarget() {
        return this.navigationTarget;
    }

    public void setPath(String path) {
        this.path = path;
        if (!this.disabled) {
            super.setPath(path);
        }
    }

    public void setEnabled(boolean enabled) {
        boolean bl = this.disabled = !enabled;
        if (this.disabled) {
            super.setPath((String)null);
        } else if (this.path != null) {
            super.setPath(this.path);
        }
        String color = enabled ? "" : "gray";
        this.getStyle().setColor(color);
    }

    public boolean isEnabled() {
        return !this.disabled;
    }
}

