/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.firitin.components;

import com.vaadin.flow.component.html.Div;
import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.MutableDataSet;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import org.apache.commons.io.IOUtils;
import org.jsoup.Jsoup;
import org.jsoup.safety.Safelist;

public class RichText
extends Div {
    private static final long serialVersionUID = -6926829115110918731L;
    private static Parser parser;
    private static HtmlRenderer renderer;
    private transient Safelist safelist;
    private String richText;

    public RichText() {
        this.setWidth("100%");
    }

    public RichText(String content) {
        this.setWidth("100%");
        this.setRichText(content);
    }

    protected Parser getMdParser() {
        if (parser == null) {
            MutableDataSet options = new MutableDataSet();
            parser = Parser.builder((DataHolder)options).build();
        }
        return parser;
    }

    protected HtmlRenderer getMdRenderer() {
        if (renderer == null) {
            renderer = HtmlRenderer.builder().build();
        }
        return renderer;
    }

    public RichText withMarkDown(String markdown) {
        return this.setRichText(this.getMdRenderer().render((Node)this.getMdParser().parse(markdown)));
    }

    public RichText withMarkDown(InputStream markdown) {
        try {
            return this.setRichText(this.getMdRenderer().render((Node)this.getMdParser().parseReader((Reader)new InputStreamReader(markdown))));
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public RichText withSafeHtml(String html) {
        return this.setRichText(html);
    }

    public RichText withSafeHtml(InputStream markdown) {
        try {
            return this.setRichText(IOUtils.toString((InputStream)markdown, (String)"UTF-8"));
        }
        catch (IOException ex) {
            throw new RuntimeException("Input stream coulnd't be read!", ex);
        }
    }

    public RichText withNewLines(String text) {
        return this.setRichText(text.replaceAll("(\\r|\\n|\\r\\n)+", "<br />"));
    }

    @Deprecated
    public Safelist getWhitelist() {
        return this.getSafelist();
    }

    public Safelist getSafelist() {
        if (this.safelist == null) {
            return Safelist.relaxed();
        }
        return this.safelist;
    }

    @Deprecated
    public RichText setSafelist(Safelist whitelist) {
        this.safelist = whitelist;
        return this;
    }

    @Deprecated
    public String getText() {
        return this.richText;
    }

    public RichText setRichText(String text) {
        this.getElement().executeJs("this.innerHTML = $0", new Serializable[]{Jsoup.clean((String)text, (Safelist)this.getWhitelist())});
        return this;
    }

    public RichText setRichTextAndSaveReference(String text) {
        this.richText = text;
        this.getElement().setProperty("innerHTML", Jsoup.clean((String)this.richText, (Safelist)this.getWhitelist()));
        return this;
    }

    public RichText withMarkDownResource(String resourceName) {
        return this.withMarkDown(((Object)((Object)this)).getClass().getResourceAsStream(resourceName));
    }

    public RichText withSafeHtmlResource(String resourceName) {
        return this.withSafeHtml(((Object)((Object)this)).getClass().getResourceAsStream(resourceName));
    }

    public RichText withContent(String content) {
        return this.setRichText(content);
    }
}

