/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.firitin.components.messagelist;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.HasSize;
import com.vaadin.flow.component.HasStyle;
import com.vaadin.flow.component.Tag;
import com.vaadin.flow.component.UI;
import com.vaadin.flow.dom.Element;
import com.vaadin.flow.dom.Style;
import com.vaadin.flow.server.Command;
import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.MutableDataSet;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import org.apache.commons.lang3.StringUtils;

@Tag(value="vaadin-message")
public class MarkdownMessage
extends Component
implements HasStyle,
HasSize {
    private static final String PLACEHOLDER = "...";
    private static HtmlRenderer renderer;
    private static Parser parser;
    private UI ui;
    private String markdown;
    private String previousHtml;
    private boolean autoScroll = true;
    private Element content = new Element("div");
    private Element scrollHelper = new Element("div");

    public MarkdownMessage(String name, LocalDateTime timestamp, Color color) {
        if (color != null) {
            this.setAvatarColor(color);
        }
        this.getElement().setProperty("userName", name);
        this.getElement().setProperty("time", timestamp.format(DateTimeFormatter.ofPattern("YYYY-MM-dd hh:mm")));
        this.getElement().appendChild(new Element[]{this.content, this.scrollHelper});
        this.content.getStyle().setWhiteSpace(Style.WhiteSpace.NORMAL);
    }

    public MarkdownMessage(String name) {
        this(name, LocalDateTime.now(), Color.AVATAR_PRESETS[0]);
        this.setMarkdown(null);
    }

    public MarkdownMessage(String name, LocalDateTime timestamp) {
        this(name, timestamp, Color.AVATAR_PRESETS[0]);
        this.setMarkdown(null);
    }

    public MarkdownMessage(String name, Color avatarColor) {
        this(name, LocalDateTime.now(), avatarColor);
        this.setMarkdown(null);
    }

    public MarkdownMessage(String markdown, String name, Color avatarColor) {
        this(name, LocalDateTime.now(), avatarColor);
        this.setMarkdown(markdown);
    }

    public MarkdownMessage(String markdown, String name) {
        this(name, LocalDateTime.now(), Color.AVATAR_PRESETS[name.hashCode() % Color.AVATAR_PRESETS.length]);
        this.setMarkdown(markdown);
    }

    public MarkdownMessage(String markdown, String name, LocalDateTime timestamp) {
        this(name, timestamp, null);
        this.setMarkdown(markdown);
    }

    public void setAvatarColor(Color color) {
        this.getElement().getStyle().set("--vaadin-avatar-user-color", color.cssColorCode);
        this.getElement().executeJs("$0.querySelector('vaadin-avatar').style.setProperty('--vaadin-avatar-user-color', null);$0.querySelector('vaadin-avatar').setAttribute('has-color-index', true);", new Serializable[0]);
    }

    public void setUserColorIndex(int index) {
        this.getElement().setProperty("userColorIndex", (double)index);
    }

    public String getMarkdown() {
        return this.markdown;
    }

    protected void setMarkdown(String markdown, boolean uiAccess) {
        String html;
        this.markdown = markdown == null ? PLACEHOLDER : markdown;
        this.previousHtml = html = this.getMdRenderer().render((Node)this.getMdParser().parse(this.markdown));
        if (uiAccess) {
            this.getUi().access((Command & Serializable)() -> this.appendHtml(html, 0));
        } else {
            this.appendHtml(html, 0);
        }
    }

    public void setMarkdown(String markdown) {
        this.setMarkdown(markdown, false);
    }

    private void appendHtml(String html) {
        this.getElement().executeJs("if(this.curHtml) {\n    this.curHtml = this.curHtml + $0;\n} else {\n    this.curHtml = $0;\n}\n$1.innerHTML = this.curHtml;\n", new Serializable[]{html, this.content});
    }

    private void appendHtml(String html, int replaceFrom) {
        this.getElement().executeJs("this.curHtml = this.curHtml ? this.curHtml.substring(0, $2) + $0 : $0;\n$1.innerHTML = this.curHtml;\n", new Serializable[]{html, this.content, Integer.valueOf(replaceFrom)});
    }

    protected HtmlRenderer getMdRenderer() {
        if (renderer == null) {
            renderer = HtmlRenderer.builder().build();
        }
        return renderer;
    }

    protected Parser getMdParser() {
        if (parser == null) {
            MutableDataSet options = new MutableDataSet();
            parser = Parser.builder((DataHolder)options).build();
        }
        return parser;
    }

    protected void onAttach(AttachEvent attachEvent) {
        super.onAttach(attachEvent);
        this.ui = attachEvent.getUI();
    }

    public UI getUi() {
        if (this.ui == null) {
            this.ui = this.ui.getUI().orElseGet(() -> UI.getCurrent());
        }
        return this.ui;
    }

    public void appendMarkdown(String markdownSnippet) {
        this.appendMarkdown(markdownSnippet, false);
    }

    public void appendMarkdownAsync(String markdownSnippet) {
        this.appendMarkdown(markdownSnippet, true);
    }

    protected void appendMarkdown(String markdownSnippet, boolean uiAccess) {
        Command & Serializable c;
        markdownSnippet = markdownSnippet != null ? markdownSnippet : "";
        this.markdown = this.markdown == null || PLACEHOLDER.equals(this.markdown) ? markdownSnippet : this.markdown + markdownSnippet;
        String html = this.getMdRenderer().render((Node)this.getMdParser().parse(this.markdown));
        if (this.previousHtml == null) {
            c = (Command & Serializable)() -> this.appendHtml(html);
        } else {
            String commonPrefix = StringUtils.getCommonPrefix((String[])new String[]{html, this.previousHtml});
            int startOfNew = commonPrefix.length();
            String newPart = html.substring(startOfNew);
            c = (Command & Serializable)() -> {
                this.appendHtml(newPart, startOfNew);
                this.doAutoScroll();
            };
        }
        this.previousHtml = html;
        if (uiAccess) {
            this.getUi().access((Command)c);
        } else {
            c.execute();
        }
    }

    public boolean isAutoScroll() {
        return this.autoScroll;
    }

    public void setAutoScroll(boolean autoScroll) {
        this.autoScroll = autoScroll;
    }

    protected void doAutoScroll() {
        if (this.autoScroll) {
            this.scrollHelper.executeJs("    if(this.scrollIntoViewIfNeeded) {\n        this.scrollIntoViewIfNeeded();\n    } else {\n        // FF\n        this.scrollIntoView();\n    }\n", new Serializable[0]);
        }
    }

    public record Color(String cssColorCode) {
        public static Color[] AVATAR_PRESETS = new Color[]{new Color("#df0b92"), new Color("#650acc"), new Color("#097faa"), new Color("#ad6200"), new Color("#bf16f3"), new Color("#084391"), new Color("#078836")};
    }
}

