/*
 * Decompiled with CFR 0.152.
 */
package org.vaadin.firitin.appframework;

import com.vaadin.flow.component.AttachEvent;
import com.vaadin.flow.component.Component;
import com.vaadin.flow.component.applayout.AppLayout;
import com.vaadin.flow.component.applayout.DrawerToggle;
import com.vaadin.flow.component.html.Footer;
import com.vaadin.flow.component.html.H1;
import com.vaadin.flow.component.html.H2;
import com.vaadin.flow.component.html.Header;
import com.vaadin.flow.component.orderedlayout.Scroller;
import com.vaadin.flow.component.sidenav.SideNav;
import com.vaadin.flow.component.sidenav.SideNavItem;
import com.vaadin.flow.router.AfterNavigationEvent;
import com.vaadin.flow.router.AfterNavigationObserver;
import com.vaadin.flow.router.RouteConfiguration;
import com.vaadin.flow.router.RoutesChangedListener;
import com.vaadin.flow.server.Command;
import java.io.Serializable;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.vaadin.firitin.appframework.MenuItem;
import org.vaadin.firitin.appframework.NavigationItem;

public abstract class MainLayout
extends AppLayout
implements AfterNavigationObserver {
    private H2 viewTitle;
    private SideNav menu;
    private List<NavigationItem> navigationItems = new ArrayList<NavigationItem>();
    private Stack<Component> viewStack = new Stack();
    private Map<Component, String> explicitViewTitles = new WeakHashMap<Component, String>();

    public MainLayout() {
        this.setPrimarySection(AppLayout.Section.DRAWER);
        this.addDrawerContent();
        this.addHeaderContent();
    }

    private void addHeaderContent() {
        DrawerToggle toggle = new DrawerToggle();
        toggle.getElement().setAttribute("aria-label", "Menu toggle");
        this.viewTitle = new H2();
        this.viewTitle.addClassNames(new String[]{"text-l", "m-0"});
        this.addToNavbar(true, new Component[]{toggle, this.viewTitle});
    }

    private void addDrawerContent() {
        H1 appName = new H1(this.getDrawerHeader());
        appName.getStyle().setMargin("var(--lumo-space-m)");
        appName.getStyle().set("font-size", "var(--lumo-font-size-l)");
        Header header = new Header(new Component[]{appName});
        Scroller scroller = new Scroller((Component)this.prepareNav());
        scroller.addClassNames(new String[]{"p-s"});
        this.addToDrawer(new Component[]{header, scroller, this.prepareFooter()});
    }

    protected SideNav prepareNav() {
        SideNav nav;
        this.menu = nav = new SideNav();
        return nav;
    }

    public SideNav getMenu() {
        return this.menu;
    }

    private Footer prepareFooter() {
        Footer layout = new Footer();
        return layout;
    }

    protected void onAttach(AttachEvent attachEvent) {
        if (this.navigationItems.isEmpty()) {
            this.init();
        }
        super.onAttach(attachEvent);
    }

    protected void init() {
        RouteConfiguration.forSessionScope().getAvailableRoutes().stream().filter(routeData -> {
            Class parentLayout = routeData.getParentLayout();
            if (parentLayout != null) {
                boolean assignableFrom = MainLayout.class.isAssignableFrom(parentLayout);
                return assignableFrom;
            }
            return false;
        }).forEach(rd -> {
            Class routeClass = rd.getNavigationTarget();
            if (!Modifier.isAbstract(routeClass.getModifiers())) {
                this.navigationItems.add(new NavigationItem(routeClass));
            }
        });
        RouteConfiguration.forApplicationScope().addRoutesChangeListener((RoutesChangedListener & Serializable)event -> {
            try {
                event.getRemovedRoutes().forEach(route -> {
                    Iterator<NavigationItem> iterator = this.navigationItems.iterator();
                    while (iterator.hasNext()) {
                        NavigationItem item = iterator.next();
                        if (item.getNavigationTarget() != route.getNavigationTarget()) continue;
                        iterator.remove();
                    }
                });
                this.getUI().ifPresent(ui -> {
                    if (ui.isClosing()) {
                        return;
                    }
                    ui.access((Command & Serializable)() -> {
                        List addedRoutes = event.getAddedRoutes();
                        addedRoutes.stream().filter(routeData -> {
                            Class parentLayout = routeData.getParentLayout();
                            if (parentLayout != null) {
                                boolean assignableFrom = MainLayout.class.isAssignableFrom(parentLayout);
                                return assignableFrom;
                            }
                            return false;
                        }).forEach(rd -> {
                            Class routeClass = rd.getNavigationTarget();
                            if (!Modifier.isAbstract(routeClass.getModifiers()) && routeClass != null) {
                                this.navigationItems.add(new NavigationItem(routeClass));
                            }
                        });
                        this.sortMenuItems();
                        this.buildMenu();
                    });
                });
            }
            catch (Exception e) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.WARNING, "Error updating routes, happens with latest Vaadin versions & JRebel sometimes", e);
            }
        });
        this.sortMenuItems();
        this.buildMenu();
    }

    protected void sortMenuItems() {
        Collections.sort(this.navigationItems, new Comparator<NavigationItem>(){

            @Override
            public int compare(NavigationItem o1, NavigationItem o2) {
                int order2;
                MenuItem a1 = o1.getNavigationTarget().getAnnotation(MenuItem.class);
                MenuItem a2 = o2.getNavigationTarget().getAnnotation(MenuItem.class);
                if (a1 == null && a2 == null) {
                    return o1.getText().compareTo(o2.getText());
                }
                int order1 = a1 == null ? 1000 : a1.order();
                int n = order2 = a2 == null ? 1000 : a2.order();
                if (order1 == order2) {
                    return o1.getText().compareTo(o2.getText());
                }
                return order1 - order2;
            }
        });
    }

    public List<NavigationItem> getNavigationItems() {
        if (this.navigationItems.isEmpty()) {
            this.init();
        }
        return this.navigationItems;
    }

    public void buildMenu() {
        this.menu.removeAll();
        this.navigationItems.stream().filter(this::checkAccess).forEach(xva$0 -> this.menu.addItem(new SideNavItem[]{xva$0}));
    }

    protected boolean checkAccess(NavigationItem navigationItem) {
        return true;
    }

    protected abstract String getDrawerHeader();

    protected void afterNavigation() {
        super.afterNavigation();
        this.updateViewTitle();
        this.updateSelectedNavigationItem();
    }

    public void afterNavigation(AfterNavigationEvent event) {
        this.updateViewTitle();
        this.updateSelectedNavigationItem();
    }

    private void updateSelectedNavigationItem() {
        this.getNavigationItems().forEach(i -> {
            if (i.getNavigationTarget() == this.getContent().getClass()) {
                i.getElement().setAttribute("active", true);
            } else {
                i.getElement().removeAttribute("active");
            }
        });
    }

    private void updateViewTitle() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.viewStack.size(); ++i) {
            Component component;
            if (i > 0) {
                sb.append(" / ");
            }
            if (this.explicitViewTitles.containsKey(component = (Component)this.viewStack.get(i))) {
                sb.append(this.explicitViewTitles.get(component));
                continue;
            }
            sb.append(NavigationItem.getMenuTextFromClass(component.getClass()));
        }
        this.viewTitle.setText(sb.toString());
    }

    public void setContent(Component content) {
        while (this.viewStack.size() > 1) {
            this.closeSubView();
        }
        super.setContent(content);
        this.viewStack.clear();
        this.viewStack.push(content);
    }

    public void openSubView(Component component, String viewTitle) {
        this.viewStack.push(component);
        if (viewTitle != null) {
            this.explicitViewTitles.put(component, viewTitle);
        }
        super.setContent(component);
        this.updateViewTitle();
    }

    public void openSubView(Component component) {
        this.openSubView(component, null);
    }

    public void closeSubView(Component component) {
        Component pop = this.viewStack.pop();
        if (pop != component) {
            throw new IllegalStateException();
        }
        if (pop == null) {
            throw new IllegalStateException();
        }
        this.explicitViewTitles.remove(pop);
        super.setContent(this.viewStack.peek());
        this.updateViewTitle();
    }

    public void closeSubView() {
        Component pop = this.viewStack.pop();
        if (pop == null) {
            throw new IllegalStateException();
        }
        this.explicitViewTitles.remove(pop);
        super.setContent(this.viewStack.peek());
        this.updateViewTitle();
    }

    protected Footer createFooter() {
        Footer layout = new Footer();
        return layout;
    }
}

